/**
 * Created by Ong Chinh on 7/21/2016.
 */

'use strict';
(function ($) {

    $(document).ready( function () {

        /* Mailchimp */
        $('input.kd-subscribe').click( function (event) {
            event.preventDefault();

            var $self = $(this),
                $widget = $(this).closest('.widget');

            if ($('.kd-subscribe-email', $widget).val() != '') {

                $widget.addClass('kd-ajax-loading');
                $.ajax({
                    url: KD_AJAX_URL.ajaxurl,
                    type: 'POST',
                    dataType: 'html',
                    data: {action : 'kd_subscribe', email: $('.kd-subscribe-email', $widget).val(), idWidget: $widget.attr('id')},
                    success: function (response) {
                        $('.subscribe-status', $widget).empty().html(response);
                    },
                    complete: function () {
                        $widget.removeClass('kd-ajax-loading');
                    }
                })
            }
            else {
                alert('Email not empty, please try again')
            }
        });

        /* Twitter */
        $('.widget-twitter-slide').each( function () {
            $(this).owlCarousel({
                singleItem: true,
                navigation: false,
                pagination: true,
                navigationText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>']
            });
        });


    });
})(jQuery);