<?php

if ( !class_exists( 'Kd_Share_Post' ) ) {

	class Kd_Share_Post {

		/**
		 * @var
		 */
		public $list_network_default ;

		/**
		 * @var mixed|void
		 */
		public $list_network;

		/**
		 * Kd_Share_Post constructor.
		 */
		public function __construct () {

			$this->list_network_default = array(
				'facebook'    => array(
					'active'     => 'on',
					'name_class' => 'fa fa-facebook',
					'title'      => esc_html__( 'Facebook', 'kendytheme' )
				),
				'twitter'     => array(
					'active'     => 'on',
					'name_class' => 'fa fa-twitter',
					'title'      => esc_html__( 'Twitter', 'kendytheme' )
				),
				'googleplus'  => array(
					'active'     => 'on',
					'name_class' => 'fa fa-google-plus',
					'title'      => esc_html__( 'Google Plus', 'kendytheme' )
				),
				'digg'        => array(
					'active'     => 'on',
					'name_class' => 'fa fa-digg',
					'title'      => esc_html__( 'Digg', 'kendytheme' )
				),
				'reddit'      => array(
					'active'     => '',
					'name_class' => 'fa fa-reddit',
					'title'      => esc_html__( 'Reddit', 'kendytheme' )
				),
				'linkedin'    => array(
					'active'     => '',
					'name_class' => 'fa fa-linkedin',
					'title'      => esc_html__( 'LinkedIn', 'kendytheme' )
				),
				'stumbleupon' => array(
					'active'     => '',
					'name_class' => 'fa fa-stumbleupon',
					'title'      => esc_html__( 'StumbleUpon', 'kendytheme' )
				),
				'tumblr'      => array(
					'active'     => '',
					'name_class' => 'fa fa-tumblr',
					'title'      => esc_html__( 'Tumblr', 'kendytheme' )
				),
				'pinterest'   => array(
					'active'     => 'on',
					'name_class' => 'fa fa-pinterest',
					'title'      => esc_html__( 'Pinterest', 'kendytheme' )
				),
				'email'       => array(
					'active'     => '',
					'name_class' => 'fa fa-envelope',
					'title'      => esc_html__( 'Email', 'kendytheme' )
				)
			);
			$this->list_network = apply_filters( 'kd_support_share_post_settings', $this->list_network );
			$this->list_network = $this->save_settings();


			add_action( 'wp_head', array( $this, 'kd_wp_header' ) );
			add_shortcode( 'kd_share_post', array( $this, 'kd_share_post_markup' ) );
			add_filter('kd_support_sub_pages', array($this, 'kd_support_sub_pages'));
		}

		public function save_settings() {
			$list_network = get_option( 'kd_share_post' );

			if ( empty( $list_network ) ) {
				update_option( 'kd_share_post', $this->list_network_default);
			}

			if ( isset( $_POST['kd_share_post'] ) ) {
				update_option( 'kd_share_post', $_POST['kd_share_post'] );
			}

			return get_option( 'kd_share_post' );
		}

		public function kd_support_sub_pages($sub_pages) {
			$sub_pages['share_post'] = array(
				'slug'  => 'share_post',
				'title' => __( 'Share Post', 'kendytheme' )
			);
			return $sub_pages;

		}

		public function kd_wp_header () {

			if ( is_singular() && has_post_thumbnail() ) {
				$thumbnail_src = wp_get_attachment_url( get_post_thumbnail_id() );
				$theme_detail  = wp_get_theme();
				?>
				<meta property="og:type" content="article" />
				<meta property="og:title" content="<?php the_title(); ?>" />
				<meta property="og:url" content="<?php the_permalink(); ?>" />
				<meta property="og:description" content="Visit the post for more." />
				<meta property="og:site_name" content="<?php echo $theme_detail->Name; ?>" />
				<meta property="og:image" content="<?php echo esc_url( $thumbnail_src ); ?>" />
				<meta property="og:locale" content="en_US" />
				<?php
			}

		}

		public function kd_share_post_markup () {

			$media = '';
			if ( has_post_thumbnail() ) {
				$media = '&amp;media=' . urlencode( wp_get_attachment_url( get_post_thumbnail_id() ) );
			}

			$markup_socials = array(
				'facebook'    => array(
					'before' => '<a class="kd-facebook" href="http://www.facebook.com/sharer.php?u=' . urlencode( get_permalink() ) . '&amp;t=' . urlencode( get_the_title() ) . '" target="_blank" title="' . __( 'Share to Facebook', 'kendytheme' ) . '">',
					'after'  => '</a>'
				),
				'twitter'     => array(
					'before' => '<a class="kd-twitter" href="https://twitter.com/intent/tweet?text=' . urlencode( get_the_title() ) . '-' . urlencode( get_permalink() ) . '&amp;source=webclient" target="_blank"  title="' . __( 'Share to Twitter', 'kendytheme' ) . '">',
					'after'  => '</a>'
				),
				'googleplus'  => array(
					'before' => '<a class="kd-googleplus" href="https://plus.google.com/share?url=' . urlencode( get_permalink() ) . '&amp;title=' . urlencode( get_the_title() ) . '" target="_blank"  title="' . __( 'Share to Google Plus', 'kendytheme' ) . '">',
					'after'  => '</a>'
				),
				'digg'        => array(
					'before' => '<a class="kd-digg" href="http://www.digg.com/submit?url=' . urlencode( get_permalink() ) . '&amp;title=' . urlencode( get_the_title() ) . '" target="_blank"  title="Share to Digg">',
					'after'  => '</a>'
				),
				'reddit'      => array(
					'before' => '<a class="kd-reddit" href="http://reddit.com/submit?url=' . urlencode( get_permalink() ) . '&amp;title=' . urlencode( get_the_title() ) . '" target="_blank" title="' . __( 'Share to Reddit', 'kendytheme' ) . '">',
					'after'  => '</a>'
				),
				'linkedin'    => array(
					'before' => '<a class="kd-linkedin" href="http://www.linkedin.com/shareArticle?mini=true&amp;url=' . urlencode( get_permalink() ) . '&amp;title=' . urlencode( get_the_title() ) . '" target="_blank" title="' . __( 'Share to LinkedIn', 'kendytheme' ) . '">',
					'after'  => '</a>'
				),
				'stumbleupon' => array(
					'before' => '<a class="kd-stumbleupon" href="http://www.stumbleupon.com/submit?url=' . urlencode( get_permalink() ) . '&amp;title=' . urlencode( get_the_title() ) . '" target="_blank" title="' . __( 'Share to StumbleUpon', 'kendytheme' ) . '">',
					'after'  => '</a>'
				),
				'tumblr'      => array(
					'before' => '<a class="kd-tumblr" href="http://www.tumblr.com/share/link?url=' . urlencode( get_permalink() ) . '&amp;name=' . urlencode( get_the_title() ) . '" target="_blank" title="' . __( 'Share to Tumblr', 'kendytheme' ) . '">',
					'after'  => '</a>'
				),
				'pinterest'   => array(
					'before' => '<a class="kd-pinterest" href="https://pinterest.com/pin/create/button/?url=' . urlencode( get_permalink() ) . $media . '&amp;description=' . urlencode( get_the_title() ) . '" target="_blank" data-pin-do="buttonBookmark" title="' . __( 'Share to Pinterest', 'kendytheme' ) . '">',
					'after'  => '</a>'
				),
				'email'       => array(
					'before' => '<a class="kd-email" href="mailto:?Subject=' . str_replace( ' ', '%20', get_the_title() ) . '&Body=' . str_replace( ' ', '%20', 'Here is the link to the article: ' . get_permalink() ) . '" title="' . __( 'Email this article', 'kendytheme' ) . '">',
					'after'  => '</a>'
				)
			);

			$markup_socials = apply_filters( 'kd_support_share_post_markup_frontend', $markup_socials, $media );

			?>
			<div class="kd-sharing-post-social">
				<?php
				foreach ( $this->list_network as $key => $social ) {
					if ( isset( $social['active'] ) && $social['active'] === 'on' ) {
						$item = $markup_socials[ $key ];

						echo $item['before'];
						?>
						<i class="<?php echo esc_attr( $social['name_class'] ); ?>" title="<?php echo esc_attr( $social['title'] ); ?>"></i>
						<?php
						echo $item['after'];
					}
				}
				?>
			</div>
			<?php
		}

	}
}
add_action('init', 'kd_share_post_init', -999);

function kd_share_post_init() {
	$GLOBALS['Kd_Share_Post'] = new Kd_Share_Post();
}