<?php
define( 'KD_WIDGET_PREFIX', 'KENDY - ' );
define( 'KD_SUPPORT_WIDGETS_URI', KD_SUPPORT_URI . 'widgets/' );
define( 'KD_SUPPORT_WIDGETS_PATH', KD_SUPPORT_PATH . 'inc/widgets/' );

class Kd_Widget extends WP_Widget {

	public function kd_socials_data () {
		return array(
			'behance'     => array(
				'title' => esc_html__( 'Behance', 'kendytheme' ),
				'class' => 'fa fa-behance'
			),
			'dribbble'    => array(
				'title' => esc_html__( 'Dribbble', 'kendytheme' ),
				'class' => 'fa fa-dribbble'
			),
			'facebook'    => array(
				'title' => esc_html__( 'Facebook', 'kendytheme' ),
				'class' => 'fa fa-facebook'
			),
			'flickr'      => array(
				'title' => esc_html__( 'Flickr', 'kendytheme' ),
				'class' => 'fa fa-flickr'
			),
			'google_plus' => array(
				'title' => esc_html__( 'Google Plus', 'kendytheme' ),
				'class' => 'fa fa-google-plus'
			),
			'instagram'   => array(
				'title' => esc_html__( 'Instagram', 'kendytheme' ),
				'class' => 'fa fa-instagram'
			),
			'linkedin'    => array(
				'title' => esc_html__( 'Linkedin', 'kendytheme' ),
				'class' => 'fa fa-linkedin'
			),
			'mail'        => array(
				'title' => esc_html__( 'Mail', 'kendytheme' ),
				'class' => 'fa fa-envelope'
			),
			'pinterest'   => array(
				'title' => esc_html__( 'Pinterest', 'kendytheme' ),
				'class' => 'fa fa-pinterest'
			),
			'skype'       => array(
				'title' => esc_html__( 'Skype', 'kendytheme' ),
				'class' => 'fa fa-skype'
			),
			'tumblr'      => array(
				'title' => esc_html__( 'Tumblr', 'kendytheme' ),
				'class' => 'fa fa-tumblr'
			),
			'twitter'     => array(
				'title' => esc_html__( 'Twitter', 'kendytheme' ),
				'class' => 'fa fa-twitter'
			),
			'vimeo'       => array(
				'title' => esc_html__( 'Vimeo', 'kendytheme' ),
				'class' => 'fa fa-vimeo-square'
			),
			'yahoo'       => array(
				'title' => esc_html__( 'Yahoo', 'kendytheme' ),
				'class' => 'fa fa-yahoo'
			),
			'youtube'     => array(
				'title' => esc_html__( 'Youtube', 'kendytheme' ),
				'class' => 'fa fa-youtube-play'
			)
		);
	}

	/**
	 * @param       $text
	 * @param array $images
	 */
	public function kd_item_description ( $text, $images = array() ) {
		?>
		<p class="kd-description">
		<?php echo $text; ?>
		<?php
		if ( ! empty( $images ) && is_array( $images ) ) {
			?>
			<div class="kd-images-description">
				<?php
				foreach ( $images as $image ) {
					?>
					<a class="kd-image" href="<?php echo esc_url( $image ); ?>">
						<img src="<?php echo esc_url( $image ); ?>" />
					</a>
					<?php
				}
				?>
			</div>
			<?php
		}
		?>
		</p>
		<?php
	}

	/**
	 * @param $text
	 */
	public function kd_item_heading ( $text ) {
		?>
		<h2 class="kd-heading">
			<?php echo $text; ?>
		</h2>
		<?php
	}

	/**
	 * @param $id
	 * @param $label
	 * @param $name
	 * @param $value
	 */
	public function kd_item_text ( $id, $label, $name, $value ) {
		?>
		<p>
			<label for="<?php echo $this->get_field_id( $id ); ?>">
				<?php echo $label; ?>
			</label>
			<input class="widefat" id="<?php echo $this->get_field_id( $id ); ?>" name="<?php echo $this->get_field_name( $name ); ?>" type="text" value="<?php echo esc_attr( $value ); ?>" />
		</p>
		<?php
	}

	/**
	 * @param $id
	 * @param $name
	 * @param $value
	 */
	public function kd_item_text_hidden ( $id, $name, $value ) {
		?>
		<input class="widefat" id="<?php echo $this->get_field_id( $id ); ?>" name="<?php echo $this->get_field_name( $name ); ?>" type="hidden" value="<?php echo esc_attr( $value ); ?>" />
		<?php
	}

	/**
	 * @param $id
	 * @param $label
	 * @param $name
	 * @param $value
	 */
	public function kd_item_textarea ( $id, $label, $name, $value ) {
		?>
		<p>
			<label for="<?php echo $this->get_field_id( $id ); ?>">
				<?php echo $label; ?>
			</label>
			<textarea name="<?php echo $this->get_field_name( $name ); ?>" id="<?php echo $this->get_field_id( $id ); ?>"><?php echo $value; ?></textarea>
		</p>
		<?php
	}

	/**
	 * @param       $id
	 * @param       $label
	 * @param       $name
	 * @param       $value
	 * @param array $options
	 */
	public function kd_item_select ( $id, $label, $name, $value, $options = array() ) {
		?>
		<p>
			<label for="<?php echo $this->get_field_id( $id ); ?>"><?php echo $label; ?></label>
			<select id="<?php echo $this->get_field_id( $id ); ?>" name="<?php echo $this->get_field_name( $name ); ?>">
				<?php
				foreach ( $options as $key => $item ) {
					?>
					<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $value ); ?>><?php echo esc_html( $item ); ?></option>
					<?php
				}
				?>
			</select>
		</p>
		<?php
	}

	/**
	 * @param        $id
	 * @param        $label
	 * @param        $name
	 * @param        $value
	 * @param bool   $multiple
	 * @param string $image_size
	 */
	public function kd_item_media ( $id, $label, $name, $value, $multiple = false, $image_size = 'thumbnail' ) {
		?>
		<p>
			<label for="<?php echo $this->get_field_id( $id ); ?>">
				<?php echo $label; ?>
			</label>
		</p>
		<div id="kd-<?php echo $this->get_field_id( $id ); ?>">
			<div class="wrap-media">
				<div class="kd-upload" data-parent=".kd-<?php echo $this->get_field_id( $id ); ?> .kd-img-container" data-multiple="<?php echo esc_attr( $multiple ); ?>" data-image-size="<?php echo esc_attr( $image_size ); ?>">
					<input class="kd-media-value" type="hidden" />
					<input id="kd_field_<?php echo $this->get_field_id( $id ); ?>" class="kd-media-input" name="<?php echo $this->get_field_name( $name ); ?>" value="<?php echo esc_attr( $value ); ?>" type="hidden" />

					<div class="kd-img-container">
						<?php
						if ( $value != '' ) :
							$value = explode( ',', $value );
							?>
							<ul class="list-kd-image-media">
								<?php
								foreach ( $value as $src ) {
									?>
									<li class="kd-image">
										<img src="<?php echo esc_url( trim( $src ) ); ?>" />
										<div class="kd-control-wrap">
											<i class="kd-edit dashicons dashicons-edit"></i>
											<i class="kd-close dashicons dashicons-no-alt"></i>
										</div>
									</li>
									<?php
								}
								?>
							</ul>
							<?php
						endif;
						?>
					</div>
					<a href="#" class="button kd-button kd-btn-upload"><?php esc_html_e( 'Upload', 'kendytheme' ); ?></a>
				</div>
			</div>
		</div>
		<?php
	}

	/**
	 * @param $id
	 * @param $label
	 * @param $name
	 * @param $value
	 */
	public function kd_item_colorpicker ( $id, $label, $name, $value ) {
		?>
		<p>
			<label for="<?php echo $this->get_field_id( $id ); ?>">
				<?php echo $label; ?>
			</label>
			<input class="widefat kd-colorpicker" id="<?php echo $this->get_field_id( $id ); ?>" name="<?php echo $this->get_field_name( $name ); ?>" type="text" value="<?php echo esc_attr( $value ); ?>" />
		</p>
		<?php
	}

	/**
	 * @param string $image_size
	 * @param string $post_id
	 *
	 * @return string
	 */
	public function kd_get_image_thumbnail ( $image_size = 'thumbnail', $post_id = '' ) {
		$image = '';

		if ( empty( $post_id ) ) {
			$post_id = get_the_ID();
		}

		if ( has_post_thumbnail( $post_id ) ) {
			$attachment_id = get_post_thumbnail_id( $post_id );
			$image         = wp_get_attachment_image_src( $attachment_id, $image_size );

			if ( $image ) {
				$image = $image[0];
			}
		}

		return $image;
	}

}

class Kd_Widgets {

	public $dir_widgets_default = KD_SUPPORT_WIDGETS_PATH;

	public $dir_widgets;

	public $widgets_active = array(
		'about'            => 'on',
		'banner'           => 'on',
		'contact'          => 'on',
		'flickr'           => 'on',
		'follow'           => 'on',
		'instagram'        => 'on',
		'likebox_facebook' => 'on',
		'mailchimp'        => 'on',
		'popular_posts'    => 'on',
		'random_posts'     => 'on',
		'latest_posts'     => 'on',
		'twitter'          => 'on',
	);

	public function __construct () {

		$this->widgets_active = apply_filters( 'kd_support_widgets_active', $this->widgets_active );
		$dir_widgets = get_template_directory() . '/core/kd-plugins/kd-supports/widgets/';

		if ( file_exists( $dir_widgets ) ) {
			$this->dir_widgets = $dir_widgets;
		} else {
			$this->dir_widgets = $this->dir_widgets_default;
		}
		$this->dir_widgets = apply_filters( 'kd_support_dir_widgets', $this->dir_widgets );
		$this->save_settings();
		$this->require_widgets();

		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'wp_enqueue_scripts' ), 200 );
		add_filter( 'kd_support_sub_pages', array( $this, 'kd_support_sub_pages' ) );

	}

	public function kd_support_sub_pages ( $sub_pages ) {

		$sub_pages['widgets'] = array(
			'slug'  => 'widgets',
			'title' => __( 'Widgets', 'kendytheme' )
		);

		return $sub_pages;

	}

	public function save_settings () {

		$kd_active_widgets = get_option( 'kd_active_widgets' );

		if ( empty( $kd_active_widgets ) ) {
			update_option( 'kd_active_widgets', $this->widgets_active );
		}

		if ( isset( $_POST['kd_active_widgets'] ) ) {
			update_option( 'kd_active_widgets', $_POST['kd_active_widgets'] );
		}
	}

	public function require_widgets () {
		$kd_active_widgets = (array)get_option( 'kd_active_widgets' );

		foreach ( $this->widgets_active as $slug => $widget ) {

			if ( ! empty( $kd_active_widgets[ $slug ] ) && $kd_active_widgets[ $slug ] === 'on' ) {
				if ( file_exists( $this->dir_widgets . $slug . '.php' ) ) {
					require_once( $this->dir_widgets . $slug . '.php' );
				}
				else {
					require_once( $this->dir_widgets_default . $slug . '.php' );
				}
			}

		}
	}

	public function admin_enqueue_scripts () {
		$screen = get_current_screen();
		if ( ! empty( $screen ) && ! empty( $screen->id ) && $screen->id == 'widgets' ) {
			wp_enqueue_media();
			wp_enqueue_script( 'jquery-ui-sortable' );

			wp_enqueue_style( 'magnificpopup', KD_SUPPORT_WIDGETS_URI . 'backend/magnific-popup.css', array(), KD_SUPPORT_VER );
			wp_enqueue_style( 'kd_widgets_style', KD_SUPPORT_WIDGETS_URI . 'backend/styles.css', array(), KD_SUPPORT_VER );
			wp_enqueue_script( 'magnificpopup', KD_SUPPORT_WIDGETS_URI . 'backend/jquery.magnific-popup.min.js', array(
				'jquery',
				'wp-color-picker'
			), KD_SUPPORT_VER, true );
			wp_enqueue_script( 'kd_widget_scripts', KD_SUPPORT_WIDGETS_URI . 'backend/scripts.js', array(
				'jquery',
				'wp-color-picker'
			), KD_SUPPORT_VER, true );
		}
	}

	public function wp_enqueue_scripts () {
		wp_enqueue_style( 'kd_widgets_style', KD_SUPPORT_WIDGETS_URI . 'frontend/styles.css', array(), '1.0' );
		wp_enqueue_script( 'kd_widget_scripts', KD_SUPPORT_WIDGETS_URI . 'frontend/scripts.js', array( 'jquery' ), '1.0', true );
		wp_localize_script( 'kd_widget_scripts', 'KD_AJAX_URL', array(
			'ajaxurl' => admin_url( 'admin-ajax.php' )
		) );
	}
}

add_action('widgets_init', 'kd_register_widgets', -999);

function kd_register_widgets() {
	$GLOBALS['Kd_Widgets'] = new Kd_Widgets;
}


