<?php
class Kd_Widget_About extends Kd_Widget {

	public $defaults = array(
		'title'       => 'About',
		'image'       => '',
		'information' => ''
	);

	public function __construct () {
		$widget_ops = array(
			'classname' => 'kd-about',
		);
		parent::__construct( 'kd_about', KD_WIDGET_PREFIX . esc_html__( 'About', 'kendytheme' ), $widget_ops );
	}

	public function form ( $instance ) {

		$instance = array_merge( $this->defaults, $instance );

		$this->kd_item_text( 'title', esc_html__( 'Title', 'kendytheme' ), 'title', $instance['title'] );
		$this->kd_item_media( 'image', esc_html__( 'Image', 'kendytheme' ), 'image', $instance['image'], false, 'large' );
		$this->kd_item_textarea( 'information', esc_html__( 'Information', 'kendytheme' ), 'information', $instance['information'] );
	}

	public function widget ( $args, $instance ) {
		$title = apply_filters( 'widget_title', $instance['title'] );

		echo wp_kses_post($args['before_widget']);
		if ( ! empty( $title ) ) {
			echo wp_kses_post($args['before_title'] . $title . $args['after_title']);
		}

		?>
		<div class="widget-header clearfix">
			<?php

			if ( ! empty( $instance['image'] ) ) {
				?>
				<div class="wrap-image" style="background-image: url(<?php echo esc_url($instance['image']); ?>);">
					<img src="<?php echo esc_url( $instance['image'] ); ?>" alt="<?php echo esc_attr( $instance['title'] ); ?>">
				</div>
				<?php
			}
			?>
		</div>

		<div class="widget-content">
			<?php
			if ( ! empty( $instance['information'] ) ) {
				?>
				<p class="description">
					<?php echo wp_kses_post( $instance['information'] ); ?>
				</p>
				<?php
			}
			?>

		</div>
		<?php
		echo wp_kses_post($args['after_widget']);
	}

}

add_action( 'widgets_init', 'kd_register_about' );
function kd_register_about () {
	register_widget( 'Kd_Widget_About' );
}
