<?php
class Kd_Widget_Instagram extends Kd_Widget {

	public $defaults = array(
		'title' => 'Instagram',
		'access_token' => '2540620852.1677ed0.787c88cbc2be41b99378488a376aee23',
		'number_photo' => '9'
	);

	public function __construct() {
		$widget_ops = array(
			'classname' => 'kd-instagram kd-images',
		);
		parent::__construct('kd_instagram', KD_WIDGET_PREFIX . esc_html__('Instagram', 'kendytheme'), $widget_ops);
	}

	public function form($instance) {
		$instance = array_merge($this->defaults, $instance);

		$this->kd_item_text('title', esc_html__('Title', 'kendytheme'), 'title', $instance['title']);
		$this->kd_item_text('access_token', esc_html__('Access Token', 'kendytheme'), 'access_token', $instance['access_token']);
		$this->kd_item_description('<a target="_blank" href="http://instagram.pixelunion.net/">Get Access Token</a>');
		$this->kd_item_text('number_photo', esc_html__('Number Photos', 'kendytheme'), 'number_photo', $instance['number_photo']);
	}

	public function widget($args, $instance) {
		$title = apply_filters('widget_title', $instance['title']);
		$error = false;

		echo wp_kses_post($args['before_widget']);
		if (!empty($title)) {
			echo wp_kses_post($args['before_title'] . $title . $args['after_title']);
		}
		?>
		<div class="kd-content">
			<?php
			if (!empty($instance['access_token']) && !empty($instance['number_photo'])) {
				$user_id = explode('.',$instance['access_token']);
				$user_id = $user_id[0];
				$url = 'https://api.instagram.com/v1/users/'.esc_attr($user_id).'/media/recent?access_token='.esc_attr($instance['access_token']).'&count='.esc_attr($instance['number_photo']);
				$response = wp_remote_get(esc_url_raw($url), array('decompress' => false));

				if (!is_wp_error($response)) {
					$response = wp_remote_retrieve_body($response);
					$response = json_decode($response, true);

					if (!empty($response['data'])) {
						for($i = 0; $i < (int)$instance['number_photo']; $i++) {
							if (!empty($response['data'][$i])) {
								$caption = esc_html__('Instagram Feed', 'kendytheme');
								if (!empty($response['data'][$i]['caption']['text'])) {
									$caption = !empty($response['data'][$i]['caption']['text']);
								}
								?>
								<div class="item">
									<a href="<?php echo esc_url($response['data'][$i]['link']); ?>">
										<img src="<?php echo esc_url($response['data'][$i]['images']['thumbnail']['url'])?>" alt="<?php echo esc_attr($caption); ?>"/>									</a>
								</div>
								<?php
							}
						}
					}
					else {
						$error = true;
					}
				}
				else {
					$error = true;
				}
			}
			else {
				$error = true;
			}

			if ($error) {
				?>
				<p>
					<?php esc_html_e('Please check your instagram settings and try again.', 'kendytheme'); ?>
				</p>
				<?php
			}
			?>
		</div>
		<?php
		echo wp_kses_post($args['after_widget']);
	}
}
add_action('widgets_init', 'kd_register_instagram');
function kd_register_instagram() {
	register_widget('Kd_Widget_Instagram');
}

