<?php
class Kd_Widget_Latest extends Kd_Widget {

	public $defaults = array(
		'title' => 'Latest Posts',
		'number_posts' => '3',
		'layout' => ''
	);

	public function __construct() {
		$widget_ops = array(
			'classname' => 'kd-latest-posts kd-posts-list',
		);
		parent::__construct('kd_latest_posts', KD_WIDGET_PREFIX . esc_html__('Latest Posts', 'kendytheme'), $widget_ops);
	}

	public function form($instance) {
		$instance = array_merge($this->defaults, $instance);
		$this->kd_item_text('title', esc_html__('Title', 'kendytheme'), 'title', $instance['title']);
		$this->kd_item_text('number_posts', esc_html__('Number Posts', 'kendytheme'), 'number_posts', $instance['number_posts']);
		$this->kd_item_select('layout', esc_html__('Layout', 'kendytheme'), 'layout', $instance['layout'], array(
			'image' => esc_html__('Image', 'kendytheme'),
			'number' => esc_html__('Number', 'kendytheme')
		));
	}

	public function widget($args, $instance) {
		$title = apply_filters('widget_title', $instance['title']);

		echo wp_kses_post($args['before_widget']);
		if (!empty($title)) {
			echo wp_kses_post($args['before_title'] . $title . $args['after_title']);
		}

		$arg_query = array(
			'post_type' => 'post',
			'ignore_sticky_posts' => true,
			'order' => 'DESC',
			'posts_per_page' => (int)$instance['number_posts']
		);

		$kd_query = new WP_Query($arg_query);
		$count = 0;
		$class_wrap = 'widget-list';

		if ($instance['layout'] === 'number') {
			$class_wrap .= ' classic';
		}

		if ($kd_query->have_posts()) {
			?>
			<div class="<?php echo esc_attr($class_wrap); ?>">
				<?php
				while($kd_query->have_posts()) {

					$kd_query->the_post();
					$image = $this->kd_get_image_thumbnail('elegance_800x500');
					?>
					<div class="item clearfix">
						<?php
						if ($instance['layout'] !== 'number') {
							if (!empty($image)) {
								?>
								<div class="image" style="background-image: url('<?php echo esc_url($image); ?>'); ">
									<img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr(get_the_title()); ?>">
								</div>
								<?php
							}
							else {
								?>
								<div class="image"></div>
								<?php
							}
							?>
							<div class="widget-item-content">
								<h3 class="title">
									<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
								</h3>
								<?php elegance_details(); ?>
							</div>
							<?php
						}
						else {
							$count++;

							if ($count <10) {
								$count = '0' . $count;
							}
							?>
							<div class="number"><?php echo wp_kses_post($count); ?></div>
							<div class="widget-item-content">
								<h3 class="title">
									<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
								</h3>
							</div>
							<?php
						}
						?>
					</div>
					<?php
				}
				?>
			</div>
			<?php
		}
		wp_reset_postdata();
		echo wp_kses_post($args['after_widget']);
	}
}

add_action('widgets_init', 'kd_register_latest');
function kd_register_latest() {
	register_widget('Kd_Widget_Latest');
}

