<?php
class Kd_Widget_LikeBox extends Kd_Widget {

	public $defaults = array(
		'title' => 'Facebook Like Box',
		'iframe' => ''
	);

	public function __construct() {
		$widget_ops = array(
			'classname' => 'kd-likebox',
		);
		parent::__construct('kd_likebox', KD_WIDGET_PREFIX . esc_html__('Facebook LikeBox', 'kendytheme'), $widget_ops);
	}

	public function form($instance) {
		$instance = array_merge($this->defaults, $instance);
		$this->kd_item_text('title', esc_html__('Title', 'kendytheme'), 'title', $instance['title']);
		$this->kd_item_textarea('iframe', esc_html__('Fan Page Iframe', 'kendytheme'), 'iframe', $instance['iframe']);
		$this->kd_item_description('Access <a href="https://developers.facebook.com/docs/plugins/page-plugin">link</a> and follow the below instructions', array(
			'http://c8.staticflickr.com/9/8179/28468272815_cb9b703807_h.jpg',
			'http://c3.staticflickr.com/9/8565/27851885314_1a2a283a60_h.jpg',
			'http://c6.staticflickr.com/9/8464/28390061821_8484b79842_h.jpg'
		));
	}

	public function widget($args, $instance) {
		$title = apply_filters('widget_title', $instance['title']);

		echo wp_kses_post($args['before_widget']);
		if (!empty($title)) {
			echo wp_kses_post($args['before_title'] . $title . $args['after_title']);
		}
		?>
		<div class="widget-likebox-content">
			<?php
			if (!empty($instance['iframe'])) {
				echo wp_kses($instance['iframe'], array(
					'iframe' => array(
						'src'             => array(),
						'height'          => array(),
						'width'           => array(),
						'frameborder'     => array(),
						'allowfullscreen' => array(),
					)
				));
			}
			?>
		</div>
		<?php
		echo wp_kses_post($args['after_widget']);
	}
}
add_action('widgets_init', 'kd_register_likebox');
function kd_register_likebox() {
	register_widget('Kd_Widget_LikeBox');
}
