<?php
/*
Plugin Name: KendyTheme Support
Plugin URI: http://kendytheme.net
Author: KendyThemes
Author URI: http://kendytheme.net
Version: 1.0.5
Description: One click import demo, Document Online, Related Themes, Support
Text Domain: kendytheme
Domain Path: /languages/
*/

defined( 'ABSPATH' ) || exit;

define( 'KD_SUPPORT_URI', plugin_dir_url( __FILE__ ) . 'assets/' );
define( 'KD_SUPPORT_PATH', trailingslashit( plugin_dir_path( __FILE__ ) ) );
define( 'KD_SUPPORT_VER', '1.0.5' );

if ( ! class_exists( 'Kd_Support' ) ) {

	class Kd_Support {

		/**
		 * @var
		 */
		public $dir_templates;

		/**
		 * @var mixed|void
		 */
		public $dir_default_templates;


		public $KD_SUPPORT_VERSION = '1.0.5';

		public $theme_options_name = 'kd_theme_options';

		/**
		 * @var
		 */
		public $sub_pages;

		public function __construct () {

			$this->dir_default_templates = KD_SUPPORT_PATH . 'templates/';

			require 'inc/advance.php';
			require 'inc/functions.php';
			require 'inc/import-demo.php';
			require 'inc/class-kd-widgets.php';
			require 'inc/class-kd-share-post.php';
			require 'inc/class-kd-post-format.php';

			if ( ! class_exists( 'lessc' ) ) {
				require 'inc/lessc.inc.php';
			}

			$template_directory = get_template_directory() . '/core/kd-plugins/kd-supports/templates/';

			if ( file_exists( $template_directory ) ) {
				$this->dir_templates = $template_directory;
			} else {
				$this->dir_templates = $this->dir_default_templates;
			}

			add_action('init', array($this, 'hooks'));

		}

		public function hooks () {

			$this->dir_templates      = apply_filters( 'kd_support_dir_template', $this->dir_templates );
			$this->theme_options_name = apply_filters( 'kd_theme_options_name', $this->theme_options_name );

			add_action( 'admin_menu', array( $this, 'kd_add_menu' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
			add_action( 'admin_init', array( $this, 'admin_init' ) );
			add_filter( 'redux/options/' . $this->theme_options_name . '/ajax_save/response', array(
				$this,
				'compile_css'
			) );
		}

		public function admin_init () {
			new Kd_Import_Demo( array(
				'dir_templates' => $this->dir_templates
			) );
		}

		public function compile_css ( $return_array ) {

			global $wp_filesystem;
			if ( empty( $wp_filesystem ) ) {
				require_once( ABSPATH . '/wp-admin/includes/file.php' );
				WP_Filesystem();
			}

			$custom_less    = apply_filters( 'kd_support_compile_css', '', $wp_filesystem);
			$file_overwrite = trailingslashit( get_template_directory() ) . 'assets/css/variables.less';
			$file_overwrite = apply_filters( 'kd_support_compile_css_file_overwrite', $file_overwrite, $wp_filesystem );

			$compile_input = trailingslashit( get_template_directory() ) . 'assets/css/styles.less';
			$compile_input = apply_filters( 'kd_support_compile_css_input_file', $compile_input, $wp_filesystem );

			$compile_output = trailingslashit( get_template_directory() ) . 'assets/css/styles.css';
			$compile_output = apply_filters( 'kd_support_compile_css_output_file', $compile_output, $wp_filesystem );

			if ( file_exists( $file_overwrite ) && file_exists( $compile_input ) ) {

				$file = fopen($file_overwrite, 'a+');
				fwrite($file, $custom_less);
				fclose($file);

				$wp_filesystem->put_contents( $file_overwrite, $custom_less, FS_CHMOD_FILE );
				$less = new lessc;
				$less->compileFile( $compile_input, $compile_output );
			}

			return $return_array;
		}

		public function kd_add_menu () {

			$page_title = apply_filters( 'kd_support_page_title', __( 'KendyThemes', 'kendytheme' ) );
			$menu_title = apply_filters( 'kd_support_page_title', __( 'KendyThemes', 'kendytheme' ) );
			$sub_pages  = array(
				'import-demo' => array(
					'slug'  => 'import-demo',
					'title' => __( 'Import Demo', 'kendytheme' ),
				),
				'contact'     => array(
					'slug'  => 'contact',
					'title' => __( 'Contact us', 'kendytheme' ),
				)

			);

			$this->sub_pages = apply_filters( 'kd_support_sub_pages', $sub_pages );
			add_menu_page( $page_title, $menu_title, 'manage_options', 'kd-supports', array(
				$this,
				'kd_template_menu'
			), 'dashicons-sos', 100 );

		}


		public function kd_template_menu () {

			if ( file_exists( $this->dir_templates . '/kd-supports.php' ) ) {
				include $this->dir_templates . '/kd-supports.php';
			} else {
				include $this->dir_default_templates . '/kd-supports.php';
			}

		}


		public function enqueue_scripts () {
			wp_register_style( 'kd_support_style', KD_SUPPORT_URI . 'css/style.css', array(), KD_SUPPORT_VER, false );
			wp_enqueue_style( 'kd_support_style' );

			wp_register_script( 'kd_support_script', KD_SUPPORT_URI . 'js/script.js', array( 'jquery' ), KD_SUPPORT_VER, true );
			wp_enqueue_script( 'kd_support_script' );
		}

	}
}

add_action( 'plugins_loaded', 'kd_plugin_ready' );
function kd_plugin_ready () {
	$GLOBALS['Kd_Support'] = new Kd_Support();
}