<?php
$list_themes = array(
	array(
		'name'        => 'Creek - Exquisite WordPress Blog Theme',
		'url'         => 'https://themeforest.net/item/creek-exquisite-wordpress-blog-theme/17945801',
		'demo'        => 'http://template.kendytheme.net/creek/',
		'img'         => 'https://image-tf.s3.envato.com/files/213117876/preview.__large_preview.jpg',
		'description' => '<strong>Creek</strong> is a Blog theme, a exquisite WordPress blog theme with beautifully balanced pages, that gives your readers immersive browsing experience, specially crafted for bloggers like you, who seek functionality & minimal aesthetics. Designed with a high conversion-rate in mind, the theme provides a plugin that shows your popular posts on the sidebar, as well as a view count in the Posts section. Easily customizable widget areas, ready to create the template you desire with the help of our custom widgets. Creek’s layout adapts to your needs and helps present your content in the most compelling way.',
	),
	array(
		'name'        => 'Tran - Clean & Minimal Blog WordPress',
		'url'         => 'https://themeforest.net/item/tran-clean-minimal-blog-wordpress/18551304',
		'demo'        => 'http://tran.kendytheme.net/',
		'img'         => 'https://image-tf.s3.envato.com/files/215347148/preview.__large_preview.jpg',
		'description' => 'Tran is a Clean & Minimal Blog Wordpress Theme, a exquisite WordPress blog theme with beautifully balanced pages, that gives your readers immersive browsing experience, specially crafted for bloggers like you, who seek functionality & minimal aesthetics. Designed with a high conversion-rate in mind, the theme provides a plugin that shows your popular posts on the sidebar, as well as a view count in the Posts section. Easily customizable widget areas, ready to create the template you desire with the help of our custom widgets. Tran’s layout adapts to your needs and helps present your content in the most compelling way.',
	),
	array(
		'name'        => 'Voyager - Elegant Lifestyle Blog Theme',
		'url'         => 'https://themeforest.net/item/voyager-elegant-lifestyle-blog-theme/18906923',
		'demo'        => 'http://voyager.kendytheme.net/',
		'img'         => 'https://image-tf.s3.envato.com/files/217920717/preview.__large_preview.jpg',
		'description' => 'Voyager is a Elegant Lifestyle Blog Theme, a modern blogging theme for bloggers who love to travel, explore new places around the world and share their journeys with everyone. Designed with a high conversion-rate in mind, the theme provides a plugin that shows your popular posts on the sidebar, as well as a view count in the Posts section. Easily customize widget areas, ready to create the template you desire with the help of our custom widgets. Focus on the story and the pictures you want to share and leave the rest to Voyager. Enjoy Voyager’s ease of use and publish your stories in minutes. Discover the hidden features like, portfolios, beautiful galleries, colors and font control and many many more available right away for you!'
	)
);

shuffle( $list_themes );
?>

<div id="contact">

	<div class="document-online">
		<h2><?php _e( 'Document Online', 'kendytheme' ); ?></h2>
		<a href="#"><?php _e( 'Artistas', 'kendytheme' ); ?></a>
	</div>
	<div class="contact-via">
		<h2><?php _e( 'Contact', 'kendytheme' ) ?></h2>
		<ul>
			<li>
				<strong><?php _e( 'Gmail: ', 'kendytheme' ); ?></strong>
				<a href="mailto:kendytheme.ksb@gmail.com">kendytheme.ksb@gmail.com</a>
			</li>
			<li>
				<strong><?php _e( 'Skype:', 'kendytheme' ); ?></strong> minhct_nb
			</li>
			<li>
				<strong><?php _e( 'Themeforest', 'kendytheme' ); ?></strong>
				<a href="https://themeforest.net/user/kendythemes/portfolio">https://themeforest.net/user/kendythemes</a>
			</li>
			<li>
				<strong><?php _e( 'Website', 'kendytheme' ); ?></strong>
				<a href="http://kendytheme.net/">http://kendytheme.net/</a>
			</li>
		</ul>
	</div>
	<div class="related-themes">

		<h2><?php _e( 'Related Themes', 'kendytheme' ); ?></h2>

		<div id="kd-advertisment" class="kd-advertisment">
			<?php
			foreach ( $list_themes as $theme ) {
				$theme['url'] = add_query_arg( array(
					'ref' => 'kendythemes'
				), $theme['url'] );
				$url_demo     = add_query_arg( array(
					'ref' => 'kendythemes'
				), $theme['demo'] );

				$theme['description'] = preg_replace( '/(?<=\S,)(?=\S)/', ' ', $theme['description'] );
				$theme['description'] = str_replace( "\n", ' ', $theme['description'] );
				$theme['description'] = explode( " ", $theme['description'] );
				$theme['description'] = array_splice( $theme['description'], 0, sizeof( $theme['description'] ) - 1 );
				$theme['description'] = implode( " ", $theme['description'] ) . " ...";
				?>

				<div class="item">
					<div class="theme-thumbnail">
						<a href="<?php echo esc_url( $theme['url'] ); ?>">
							<img src="<?php echo esc_url( $theme['img'] ) ?>" />
						</a>
					</div>

					<div class="theme-detail">
						<h2><a href="<?php echo esc_url( $theme['url'] ); ?>"><?php echo $theme['name']; ?></a></h2>
						<p class="kd-description">
							<?php echo wp_kses_post( $theme['description'] ); ?>
						</p>
						<p class="theme-controls">
							<a href="<?php echo esc_url( $theme['url'] ); ?>" class="button button-primary" target="_blank">Get it now</a>
							<a href="<?php echo esc_url( $url_demo ); ?>" class="button" target="_blank">View Demo</a>
						</p>
					</div>

				</div>
				<?php
			}
			?>
		</div>
	</div>
</div>