<?php
global $Kd_Support;

$tabs = $Kd_Support->sub_pages;
$key_tabs = array_keys($tabs);
$page = $key_tabs[0];

if ( isset( $_REQUEST['tab'] ) && ! empty( $_REQUEST['tab'] ) ) {

	if (in_array($_REQUEST['tab'], $key_tabs)) {
		$page = $_REQUEST['tab'];
	}

}
?>
	<div id="kd-supports" class="kd-supports">

		<h2 class="kd-supports-controls">
			<?php
			foreach ( $tabs as $id => $tab ) {
				$class = array(
					'item-control'
				);

				if ( $page === $tab['slug'] ) {
					$class[] = 'active';
				}

				?>
				<a class="<?php echo implode( ' ', $class ); ?>" href="?page=kd-supports&tab=<?php echo esc_attr( $tab['slug'] ) ?>"><?php echo $tab['title'] ?></a>
				<?php
			}
			?>
		</h2>
		<div class="kd-supports-tabs">
			<?php
			if (file_exists($Kd_Support->dir_templates . $page .'.php')) {
				include $Kd_Support->dir_templates . $page .'.php';
			}
			else {
				if (file_exists($Kd_Support->dir_default_templates . $page .'.php')) {
					include $Kd_Support->dir_default_templates . $page .'.php';
				}
				else {
					?>
					<p><?php _e('No file exist, Please try again!', 'kendytheme')?></p>
					<?php
				}
			}

			?>
		</div>
	</div>
<?php

