(function ($) {

	'use strict';

	$.fn.kdSlider = function (opts) {

		var $self = $(this),
			defaults = {
				active: 0
			},
			options = $.extend(defaults, $self.data(), opts);

		var KdSlider = {

			$el        : $self,
			options    : options,
			$items     : [],
			$control   : $('<div class="kd-controls"><div class="next-item"></div><div class="prev-item"></div></div>'),
			$wrapSlider: $('<div class="kd-wrap-items"></div>'),

			init: function () {


				var _this = this;

				_this.createHTML();
				_this.events();

				_this.$el.data({
					'KdSlider'       : _this,
					'KdSliderOptions': _this.options
				});
			},

			createHTML: function () {

				var _this = this;

				$('> *', _this.$el).each(function (index, item) {

					_this.$items.push($(this));
					$(this).addClass('kd-item');
					_this.$wrapSlider.append(this);

				});

				_this.$el.append(_this.$wrapSlider).append(_this.$control);
				_this.activeItem(_this.options.active);

			},

			activeItem: function (index) {

				var _this = this,
					$item = _this.$items[index];

				if (_this.$currentActive) {
					_this.$currentActive.removeClass('kd-active');
				}
				$item.addClass('kd-active');
				_this.currentActive = index;
				_this.$currentActive = $item;

			},

			nextItem: function () {


				var _this = this,
					index = _this.currentActive + 1;

				if (index >= _this.totalItems) {
					index = 0;
				}

				_this.activeItem(index);
			},

			prevItem: function () {

				var _this = this,
					index = _this.currentActive - 1;

				if (index <= -1) {
					index = _this.totalItems - 1;
				}

				_this.activeItem(index);


			},

			events: function () {

				var _this = this;

				_this.$btnNext = $('.next-item', _this.$control);
				_this.$btnPrev = $('.prev-item', _this.$control);
				_this.totalItems = _this.$items.length;


				_this.$btnNext.on('click', function () {
					_this.nextItem();
				});

				_this.$btnPrev.on('click', function () {
					_this.prevItem();
				});

				$(window).resize(function () {

				});
			}

		};

		KdSlider.init();

	};

	$(document).ready(function () {

		if ($('#kd-advertisment').length) {
			$('#kd-advertisment').kdSlider();
		}

		var $kdSupports = $('#kd-supports');

		if ($kdSupports.length) {

			var $siblings = $kdSupports.prevAll(),
				$wrapNotices = $('<div class="kd-wrap-notices"></div>');

			$kdSupports.before($wrapNotices);
			// $wrapNotices.append($siblings);
		}

		/* Import Demo Data */
		var kdFiles = ['media1', 'media2', 'media3', 'media4', 'media5', 'media6', 'media7','media8', 'media9', 'media10', 'posts'],
		// var kdFiles = ['media1', 'posts'],
			kdTotal = kdFiles.length;

		$('.import-demo-data').click( function (event) {
			event.preventDefault();

			var $self = $(this);

			$('.progressbar').removeClass("hidden");

			$self.fadeOut( 500, function () {
				$(".progress-bar").css({width: '5%'});
				setTimeout(function() {
					$('.progress-btn').addClass('active');
					$('.kd-alert').html('<p>Importing...</p>');
				}, 500)
			});

			kdImportDemo(0);
		});

		function kdImportDemo(index) {

			if (index >= kdTotal) {
				$('.progress-bar').removeClass('progress-bar-danger').addClass('progress-bar-success');
				return true;
			}

			var nameFile = kdFiles[index],
				options = {
					action: 'kd-import',
					name_file: nameFile
				};

			if (index == (kdTotal - 1)) {
				options.item_last = true;
			}


			$.ajax({
				type: 'POST',
				url: ajaxurl,
				async: true,
				data: options,
				success: function (response) {
					index++;
					var percent = parseInt(index * 100/kdTotal);
					$(".progress-bar").css({width: percent +'%'});

					if (options.item_last) {
						var $content = $(response).last();
						$(".kd-alert").empty().append($content);
						$('.progress-btn').removeClass('active');
						$('.progress-succes').addClass('active');
					}
					kdImportDemo(index);
				},
				error: function () {
					kdImportDemo(index);
				}
			});
		}
	});

})(jQuery);
