/**
 * Created by Ong Chinh on 7/27/2016.
 */

'use strict';

(function ($){

    $.fn.kdGallery = function () {

        var $this = $(this),
            itemSpacing = 4;

        if ($this.hasClass('kd-tiled')) {
            $this.wrap('<div class="kd-tiled-gallery-row"></div>');
            $this.parent().css('margin', -itemSpacing);
            $this.justifiedGallery({
                rowHeight: 180,
                lastRow : 'justify',
                margins: itemSpacing
            });
        }
        else if ($this.hasClass('kd-images-slider')) {
            $this.owlCarousel({
                items: 1,
                loop: true,
                autoPlay: true,
                autoplaySpeed: 3000,
                nav: true,
                smartSpeed: 500,
                navText: '',
                dots: true
            });
        }
    };

    $.fn.kdMagnific = function () {
        $(this).magnificPopup({
            delegate: 'a',
            type: 'image',
            tLoading: 'Loading image #%curr%...',
            mainClass: 'mfp-img-mobile',
            gallery: {
                enabled: true,
                navigateByImgClick: true,
                preload: [0,1]
            },
            image: {
                tError: '<a href="%url%">The image #%curr%</a> could not be loaded.',
                titleSrc: function(item) {
                    return item.el.attr('data-caption');
                }
            }
        });
    };

    $(document).ready( function () {

        $('.kd-wrap-shortcode').each( function () {

            $('.kd-gallery', this).each( function() {
                $(this).kdGallery();
            });

            $('.kd-magnific-popup', this).each( function () {
                $(this).kdMagnific();
            });

        });

    });
})(jQuery);