<?php

class Kd_Post_Type {

	public function __construct () {
	}

	public function register_taxonomy($taxonomy, $posts_type, $args) {
		if (empty($taxonomy) || empty($posts_type) || empty($args)) {
			return;
		}
		register_taxonomy( $taxonomy, $posts_type, $args );
	}

	public function register_post_type($name, $args) {
		if (empty($name) || empty($args)) {
			return;
		}
		register_post_type( 'portfolio', $args );
	}

}

if (class_exists('WPBakeryShortCode')) {
	class Kd_VC_Shortcode extends WPBakeryShortCode {

		public $base = '';

		public function __construct ($settings = array()) {

			if (!empty($this->base)) {
				add_action( 'init', array( $this, 'mapping' ) );
				add_shortcode( $this->base, array( $this, 'frontend'), 10, 2);
			}
		}

		public function mapping() {

		}

		public function frontend($atts, $content) {

		}
	}
}

// Custom Post Type
class Kendy_Portfolio {

	public function __construct () {

		add_action( 'init', array( $this, 'post_type_project' ) );
		add_filter( 'manage_edit-portfolio_columns', array( $this, 'add_new_columns' ) );
		add_filter( 'manage_posts_custom_column', array( $this, 'custom_columns' ) );
	}

	public function post_type_project () {

		if (!class_exists('Kd_Post_Type')) {
			return;
		}
		$kd_post_type = new Kd_Post_Type();
		// Register Taxonomy
		$args_tax = array(
			'hierarchical'       => true,
			'labels'             => array(
				'name'              => _x( 'Project Categories', 'taxonomy general name', 'kendytheme' ),
				'singular_name'     => _x( 'Category', 'taxonomy singular name', 'kendytheme' ),
				'search_items'      => esc_html__( 'Search Categories', 'kendytheme' ),
				'all_items'         => esc_html__( 'All Categories', 'kendytheme' ),
				'parent_item'       => esc_html__( 'Parent Category', 'kendytheme' ),
				'parent_item_colon' => esc_html__( 'Parent Category:', 'kendytheme' ),
				'edit_item'         => esc_html__( 'Edit Category', 'kendytheme' ),
				'update_item'       => esc_html__( 'Update Category', 'kendytheme' ),
				'add_new_item'      => esc_html__( 'Add New Category', 'kendytheme' ),
				'new_item_name'     => esc_html__( 'New Category Name', 'kendytheme' ),
				'menu_name'         => esc_html__( 'Category', 'kendytheme' ),
			),
			'publicly_queryable' => true,
			'show_ui'            => true,
			'show_in_nav_menus'  => true,
			'show_admin_column'  => false,
			'query_var'          => true,
			'rewrite'            => array( 'slug' => 'project_category' ),
		);
		$args = array(
			'labels'        => array(
				'name'                  => esc_html__( 'Portfolio', 'kendytheme' ),
				'singular_name'         => esc_html__( 'Portfolio', 'kendytheme' ),
				'add_new_item'          => esc_html__( 'Add New Project', 'kendytheme' ),
				'edit_item'             => esc_html__( 'Edit Project', 'kendytheme' ),
				'new_item'              => esc_html__( 'New Project', 'kendytheme' ),
				'view_item'             => esc_html__( 'View Project', 'kendytheme' ),
				'view_items'            => esc_html__( 'View All Projects', 'kendytheme' ),
				'search_items'          => esc_html__( 'Search', 'kendytheme' ),
				'not_found'             => esc_html__( 'No projects found', 'kendytheme' ),
				'not_found_in_trash'    => esc_html__( 'No projects found in Trash', 'kendytheme' ),
				'all_items'             => esc_html__( 'All Projects', 'kendytheme' ),
				'archives'              => esc_html__( 'Project Attributes', 'kendytheme' ),
				'insert_into_item'      => esc_html__( 'Insert into project', 'kendytheme' ),
				'uploaded_to_this_item' => esc_html__( 'Uploaded to this project', 'kendytheme' ),
			),
			'public'        => true,
			'menu_position' => 7,
			'menu_icon'     => 'dashicons-schedule',
			'supports'      => array(
				'title',
				'editor',
				'thumbnail',
				'revisions',
				'post-formats'
			),
			'has_archive'   => true
		);
		$kd_post_type->register_taxonomy('project_category', array( 'portfolio' ), $args_tax );
		$kd_post_type->register_post_type('portfolio', $args);
	}

	public function add_new_columns ( $columns ) {
		$column_meta = array(
			'project_thumbnail' => esc_html__( 'Thumbnail', 'kendytheme' ),
			'project_category'  => esc_html__( 'Categories', 'kendytheme' )
		);
		$arr_key     = array_keys( $columns );
		$pos         = 0;
		if ( array_search( 'title', $arr_key ) ) {
			$pos = array_search( 'title', $arr_key );
			$pos += 1;
		}

		$columns = array_slice( $columns, 0, $pos, true ) + $column_meta + array_slice( $columns, $pos, null, true );

		return $columns;
	}

	public function custom_columns ( $column ) {
		global $post;

		switch ( $column ) {
			case 'project_thumbnail':
				if ( has_post_thumbnail() ) {
					echo get_the_post_thumbnail( get_the_ID(), array( 50, 50 ) );
				}
				break;
			case 'project_category':
				$categories = wp_get_post_terms( get_the_ID(), 'project_category' );

				foreach ( $categories as $key => $category ) {
					if ( $key ) {
						echo ', ';
					}
					?>
					<span><?php echo wp_kses_post( $category->name ); ?></span>
					<?php
				}
				break;
		}
	}
}

new Kendy_Portfolio;



