<?php
class Kd_Widget_Contact extends Kd_Widget {

	public $defaults = array(
		'title' => 'Contact Me',
		'information' => '',
		'location' => '',
		'phone' => '',
		'mail' => ''
	);

	public function __construct() {
		$widget_ops = array(
			'classname' => 'kd-contact',
		);
		parent::__construct('kd_contact', KD_WIDGET_PREFIX . esc_html__('Contact', 'kendytheme'), $widget_ops);
	}

	public function form($instance) {
		$instance = array_merge($this->defaults, $instance);
		$this->kd_item_text('title', esc_html__('Title', 'kendytheme'), 'title', $instance['title']);
		$this->kd_item_textarea('information', esc_html__('Information', 'kendytheme'), 'information', $instance['information']);
		$this->kd_item_text('location', esc_html__('Location', 'kendytheme'), 'location', $instance['location']);
		$this->kd_item_text('phone', esc_html__('Phone', 'kendytheme'), 'phone', $instance['phone']);
		$this->kd_item_text('mail', esc_html__('Mail', 'kendytheme'), 'mail', $instance['mail']);
	}

	public function widget($args, $instance) {
		$title = apply_filters('widget_title', $instance['title']);

		echo wp_kses_post($args['before_widget']);
		if (!empty($title)) {
			echo wp_kses_post($args['before_title'] . $title . $args['after_title']);
		}
		?>
		<div class="widget-content">
			<?php
			if (!empty($instance['information'])) {
				?>
				<div class="description">
					<p>
						<?php echo wp_kses_post($instance['information'])?>
					</p>
				</div>
				<?php
			}

			if (!empty($instance['location'])) {
				?>
				<div class="item-field">
					<i class="fa fa-map-marker"></i>
					<span>
                        <?php echo wp_kses_post($instance['location']); ?>
                    </span>
				</div>
				<?php
			}

			if (!empty($instance['mail'])) {
				?>
				<div class="item-field">
					<i class="fa fa-envelope"></i>
					<span>
                        <a href="mailto:<?php echo esc_attr($instance['mail']); ?>"><?php echo wp_kses_post($instance['mail']); ?></a>
                    </span>
				</div>
				<?php
			}

			if (!empty($instance['phone'])){
				?>
				<div class="item-field">
					<i class="fa fa-phone"></i>
					<span>
                        <?php echo wp_kses_post($instance['phone']); ?>
                    </span>
				</div>
				<?php
			}
			?>
		</div>
		<?php
		echo wp_kses_post($args['after_widget']);
	}
}
add_action('widgets_init', 'kd_register_contact');
function kd_register_contact() {
	register_widget('Kd_Widget_Contact');
}
