<?php

class Kd_Widget_Follow extends Kd_Widget {

	public $defaults = array(
		'behance' => '',
		'dribbble' => '',
		'facebook' => '',
		'flickr' => '',
		'google_plus' => '',
		'instagram' => '',
		'linkedin' => '',
		'mail' => '',
		'pinterest' => '',
		'skype' => '',
		'tumblr' => '',
		'twitter' => '',
		'vimeo' => '',
		'yahoo' => '',
		'youtube' => '',
	);

	public function __construct() {
		$widget_ops = array(
			'classname' => 'kd-follow',
		);
		parent::__construct('kd_follow', KD_WIDGET_PREFIX . esc_html__('Follow', 'kendytheme'), $widget_ops);
	}

	public function form($instance) {
		$instance = array_merge($this->defaults, $instance);
		$this->kd_item_text('behance', esc_html__('Behance', 'kendytheme'), 'behance', $instance['behance']);
		$this->kd_item_text('dribbble', esc_html__('Dribbble', 'kendytheme'), 'dribbble', $instance['dribbble']);
		$this->kd_item_text('facebook', esc_html__('Facebook', 'kendytheme'), 'facebook', $instance['facebook']);
		$this->kd_item_text('google_plus', esc_html__('Google Plus', 'kendytheme'), 'google_plus', $instance['google_plus']);
		$this->kd_item_text('instagram', esc_html__('Instagram', 'kendytheme'), 'instagram', $instance['instagram']);
		$this->kd_item_text('linkedin', esc_html__('Linkedin', 'kendytheme'), 'linkedin', $instance['linkedin']);
		$this->kd_item_text('mail', esc_html__('Mail', 'kendytheme'), 'mail', $instance['mail']);
		$this->kd_item_text('pinterest', esc_html__('Pinterest', 'kendytheme'), 'pinterest', $instance['pinterest']);
		$this->kd_item_text('skype', esc_html__('Skype', 'kendytheme'), 'skype', $instance['skype']);
		$this->kd_item_text('tumblr', esc_html__('Tumblr', 'kendytheme'), 'tumblr', $instance['tumblr']);
		$this->kd_item_text('twitter', esc_html__('Twitter', 'kendytheme'), 'twitter', $instance['twitter']);
		$this->kd_item_text('vimeo', esc_html__('Vimeo', 'kendytheme'), 'vimeo', $instance['vimeo']);
		$this->kd_item_text('yahoo', esc_html__('Yahoo', 'kendytheme'), 'yahoo', $instance['yahoo']);
		$this->kd_item_text('youtube', esc_html__('Youtube', 'kendytheme'), 'youtube', $instance['youtube']);
	}

	public function widget($args, $instance) {
		echo $args['before_widget'];
		?>

		<div class="widget-follow-content kd-social-square">
			<?php
			$social_data = $this->kd_socials_data();

			foreach ($social_data as $key => $item) {
				if (!empty($instance[$key])) {
					?>
					<a href="<?php echo esc_url($instance[$key]); ?>" title="<?php echo esc_attr($item['title']); ?>">
						<i class="<?php echo esc_attr($item['class'])?>"></i>
					</a>
					<?php
				}
			}
			?>
		</div>
		<?php
		echo $args['after_widget'];
	}
}
add_action('widgets_init', 'kd_register_follow');
function kd_register_follow() {
	register_widget('Kd_Widget_Follow');
}