<?php

class Kd_Widget_Mailchimp extends Kd_Widget {

	public $defaults = array(
		'title'   => 'Subscribe',
		'api_key' => '',
		'list_id' => '',
//		'description' => ''
	);

	public function __construct () {
		$widget_ops = array(
			'classname' => 'kd-mailchimp',
		);
		parent::__construct( 'kd_mailchimp', KD_WIDGET_PREFIX . esc_html__( 'Mailchimp', 'kendytheme' ), $widget_ops );

		add_action( 'wp_ajax_kd_get_list_mailchimp', array( $this, 'kd_get_list_mailchimp' ) );
		add_action( 'wp_ajax_nopriv_kd_get_list_mailchimp', array( $this, 'kd_get_list_mailchimp' ) );
		add_action( 'wp_ajax_kd_subscribe', array( $this, 'kd_subscribe' ) );
		add_action( 'wp_ajax_nopriv_kd_subscribe', array( $this, 'kd_subscribe' ) );
	}

	public function kd_get_list_mailchimp () {

		if ( isset( $_POST['api_key'] ) && ! empty( $_POST['api_key'] ) ) {
			$this->get_list( $_POST['api_key'] );
		} else {
			echo esc_html__( 'Can not get list from your MailChimp. Please check API Key and try again', 'kendytheme' );
		}
		wp_die();
	}

	public function kd_subscribe () {
		if ( isset( $_POST['email'] ) && ! empty( $_POST['email'] ) && isset( $_POST['idWidget'] ) && ! empty( $_POST['idWidget'] ) ) {

			$instance  = get_option( 'widget_kd_mailchimp' );
			$id_widget = str_replace( 'kd_mailchimp-', '', $_POST['idWidget'] );

			if ( filter_var( $_POST['email'], FILTER_VALIDATE_EMAIL ) ) {

				if ( ! empty( $instance ) && is_array( $instance ) && ! empty( $instance[ $id_widget ] ) ) {

					$widget_config = $instance[ $id_widget ];

					if ( ! empty( $widget_config['api_key'] ) && ! empty( $widget_config['list_id'] ) ) {

						require_once KD_SUPPORT_WIDGETS_PATH . 'mailchimp/Mailchimp.php';

						$mailchimp = new MailChimp( $widget_config['api_key'] );

						$result = $mailchimp->call( 'lists/subscribe', array(
							'id'                => $widget_config['list_id'],
							'email'             => array( 'email' => $_POST['email'] ),
							'double_optin'      => true,
							'update_existing'   => true,
							'replace_interests' => false,
							'send_welcome'      => false,
						) );

						if ( isset( $result['status'] ) && $result['status'] == 'error' ) {
							$output = $result['error'];
						} else {
							$output = esc_html__( 'Thank you for subscribing!', 'kendytheme' );
						}
					} else {
						$output = esc_html__( 'API key & List ID of Mailchimp isn\'t set-upped.', 'kendytheme' );
					}
				} else {
					$output = esc_html__( 'Widget Mailchimp is deleted', 'kendytheme' );
				}
			} else {
				$output = esc_html__( 'Invalid email!', 'kendytheme' );
			}

			echo wp_kses_post( $output );
		}
		wp_die();
	}

	public function get_list ( $api_key ) {

		require_once KD_SUPPORT_WIDGETS_PATH . 'mailchimp/Mailchimp.php';

		$mailchimp = new MailChimp( $api_key );
		$data      = $mailchimp->call( 'lists/list' );
		$lists     = array();

		if ( is_array( $data ) && is_array( $data['data'] ) && count( $data['data'] ) ) {
			?>
			<label><?php esc_html_e( 'Lists', 'kendytheme' ); ?></label>
			<select>
				<?php
				foreach ( $data['data'] as $item ) {
					$lists[ $item['id'] ] = $item['name'];
					?>
					<option value="<?php echo esc_attr( esc_attr( $item['id'] ) ); ?>"><?php echo wp_kses_post( $item['name'] ); ?></option>
					<?php
				}
				?>
			</select>
			<?php
		} else {
			esc_html_e( 'Can not get list from your MailChimp. Please check API Key and try again', 'kendytheme' );
		}

	}

	public function form ( $instance ) {
		$instance = array_merge( $this->defaults, $instance );
		$this->kd_item_text( 'api_key', esc_html__( 'API Key', 'kendytheme' ), 'api_key', $instance['api_key'] );
		$this->kd_item_text( 'title', esc_html__( 'Title', 'kendytheme' ), 'title', $instance['title'] );
		$this->kd_item_description( '<a href="https://admin.mailchimp.com/account/api-key-popup" target="_blank">How to get mailchimp</a>' );
		$this->kd_item_description( '<a href="#" class="button kd-getlist-mailchimp">Get List</a>' );
		?>
		<div class="kd-mailchimp-list">
			<p>
				<?php
				if ( ! empty( $instance['api_key'] ) ) {
					$this->get_list( $instance['api_key'] );
				}
				?>
			</p>
		</div>
		<?php
		$this->kd_item_text_hidden( 'list_id', 'list_id', $instance['list_id'] );
	}

	public function widget ( $args, $instance ) {
		$title = apply_filters( 'widget_title', $instance['title'] );

		echo wp_kses_post( $args['before_widget'] );

		if ( ! empty( $title ) ) {
			$title = '<span>' . $title . '</span>';

			echo wp_kses_post($args['before_title'] . $title . $args['after_title']);
		}
		?>
		<div class="widget-content">
			<?php
			if ( ! empty( $instance['api_key'] ) && ! empty( $instance['list_id'] ) ) {
				?>
				<form class="kd-subscribe">
					<div class="form-item form-remove">
						<input type="email" class="kd-subscribe-email" placeholder="<?php esc_html_e( 'Enter your email', 'kendytheme' ); ?>" value="" required />
					</div>
					<div class="form-submit icon-message-1">
						<input type="submit" class="kd-btn kd-subscribe" value="">
					</div>
				</form>
				<p class="subscribe-status"></p>
				<?php
			} else {
				?>
				<p class="kd-mailchimp-notify">
					<?php esc_html_e( 'Please check API Key & List ID and try again', 'kendytheme' ); ?>
				</p>
				<?php
			}
			?>
		</div>
		<?php

		?>
		<?php
		echo wp_kses_post( $args['after_widget'] );
	}
}

add_action( 'widgets_init', 'kd_register_mailchimp' );
function kd_register_mailchimp () {
	register_widget( 'Kd_Widget_Mailchimp' );
}
