<?php
class Kd_Widget_Twitter extends Kd_Widget {

	public $defaults = array(
		'title'               => 'Recent Tweets',
		'consumer_key'        => '',
		'consumer_secret'     => '',
		'access_token'        => '',
		'access_token_secret' => '',
		'limit'               => '2',
	);

	public function __construct () {
		$widget_ops = array(
			'classname' => 'kd-twitter',
		);
		parent::__construct( 'kd_twitter', KD_WIDGET_PREFIX . esc_html__( 'Twitter', 'kendytheme' ), $widget_ops );
	}

	public function form ( $instance ) {
		$instance = array_merge( $this->defaults, $instance );
		$this->kd_item_text( 'title', esc_html__( 'Title', 'kendytheme' ), 'title', $instance['title'] );
		$this->kd_item_text( 'consumer_key', esc_html__( 'Consumer Key', 'kendytheme' ), 'consumer_key', $instance['consumer_key'] );
		$this->kd_item_text( 'consumer_secret', esc_html__( 'Consumer Secret', 'kendytheme' ), 'consumer_secret', $instance['consumer_secret'] );
		$this->kd_item_text( 'access_token', esc_html__( 'Access Token', 'kendytheme' ), 'access_token', $instance['access_token'] );
		$this->kd_item_text( 'access_token_secret', esc_html__( 'Access Token Secret', 'kendytheme' ), 'access_token_secret', $instance['access_token_secret'] );
		$this->kd_item_text( 'limit', esc_html__( 'Limit', 'kendytheme' ), 'limit', $instance['limit'] );
		$this->kd_item_description( '<a href="https://apps.twitter.com/app/new">Create New Twitter App</a>', array(
			'//c1.staticflickr.com/9/8792/28281232080_6d4dd9b352_c.jpg',
			'//c4.staticflickr.com/9/8805/28487339011_64c3735be9_b.jpg'
		) );
	}

	public function widget ( $args, $instance ) {
		require_once KD_SUPPORT_WIDGETS_PATH . 'tweet-php-master/TweetPHP.php';

		$title = apply_filters( 'widget_title', $instance['title'] );

		echo wp_kses_post( $args['before_widget'] );
		if ( ! empty( $title ) ) {
			echo wp_kses_post( $args['before_title'] . $title . $args['after_title'] );
		}
		$class_wrap = 'widget-tweet-content';
		$TweetPHP   = new TweetPHP( array(
			'consumer_key'        => $instance['consumer_key'],
			'consumer_secret'     => $instance['consumer_secret'],
			'access_token'        => $instance['access_token'],
			'access_token_secret' => $instance['access_token_secret'],
			'tweets_to_display'   => (int)$instance['limit'],
			'cachetime'           => 0,
			'twitter_template'    => '<div class="' . $class_wrap . '">{tweets}</div>',
			'tweet_template'      => '<div class="item"><a href="{link}"><i class="fa fa-twitter"></i></a><div class="widget-item-content">{tweet}</div></div>',
			'error_template'      => '<li><span class="status">' . esc_html__( 'Our twitter feed is unavailable right now.', 'kendytheme' ) . '</span> <span class="meta"><a href="{link}">' . esc_html__( 'Follow us on Twitter', 'kendytheme' ) . '</a></span></li>'
		) );
		$html = $TweetPHP->get_tweet_list();
		echo wp_kses_post($html);

		echo wp_kses_post( $args['after_widget'] );
	}
}

add_action( 'widgets_init', 'kd_register_twitter' );
function kd_register_twitter () {
	register_widget( 'Kd_Widget_Twitter' );
}