<?php get_header(); ?>
<?php
	global $kelly_options;

	if (isset($kelly_options['404_image']['id']) &&!empty($kelly_options['404_image']['id'])) {
		$id = $kelly_options['404_image']['id'];
		$image = wp_get_attachment_image_src($id, 'kelly_600x9999');

		if (!empty($image) && isset($image[0]) && $image[0] !="") {
			$image = $image[0];
		}
		else {
			$image = '';
		}
	}
?>
	<article id="page-404" <?php post_class(); ?>>
		<?php
		if (!empty($image)) {
			?>
			<div class="post-media">
				<img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr(esc_html__('Page Not Found', 'kelly-wp')); ?>">
			</div>
			<?php
		}
		?>
		<div class="post-content">
			<!-- The Content -->
			<div class="the-content">
				<?php
				if (!empty($kelly_options['404_title'])) {
					?>
					<h2 class="title"><?php echo wp_kses_post($kelly_options['404_title']); ?></h2>
					<?php
				}
				?>
				<div class="post_404_not_found">
					<div class="page_message_404">
						<?php echo wp_kses_post($kelly_options['404_sub_title']); ?>
					</div>
					<div class="go-to-home">
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e('Back To Home', 'kelly-wp'); ?></a>
					</div>
				</div>
			</div>
			<!-- End The Content -->
		</div>

	</article>
<?php get_footer(); ?>