<?php
$post_id = get_the_ID();
$count   = get_comments_number( $post_id );

if ( $count == 0 ) {
	$title = esc_html__( 'No Comments', 'kelly-wp' );
} else if ( $count == 1 ) {
	$title = esc_html__( '1 Comment', 'kelly-wp' );
} else {
	$title = $count . esc_html__( ' Comments', 'kelly-wp' );
}
?>
	<?php
	if ( have_comments() ) {
		?>
		<!-- Comments -->
		<div id="comments">
			<h2 class="title"><?php echo wp_kses_post( $title ); ?></h2>
			<div class="comments-inner">
				<?php
				if ( post_password_required() ) {
					?>
					<div class="kelly-caption"><?php esc_html_e( 'Enter the password to view any comments.', 'kelly-wp' ); ?></div>
					<?php
				} else {
					kelly_comment_nav();
					?>
					<ul class="comment-list">
						<?php
						wp_list_comments( array(
							'avatar_size' => 50,
							'max_depth'   => 4,
							'style'       => 'ul',
							'callback'    => 'kelly_callback_comments',
							'type'        => 'all'
						) );
						?>
					</ul>
					<?php
				}
				?>
			</div>
		</div>
		<!-- End Comments -->
		<?php
	}
	?>

	<!-- Respond -->
	<?php
	if ( ! comments_open() || ! post_type_supports( get_post_type(), 'comments' ) ) {
		/**
		 * to do something
		 */
	} else {
		$current_comment = wp_get_current_commenter();
		$require_email   = get_option( 'require_name_email' );
		$aria_required   = $require_email ? 'aria-required="true"' : '';

		if ( empty( $current_comment['comment_author_subject'] ) ) {
			$current_comment['comment_author_subject'] = '';
		}

		$edit_link    = get_edit_user_link();
		$logout_link  = wp_logout_url( apply_filters( 'the_permalink', get_permalink( $post_id ) ) );
		$consent  = empty( $current_comment['comment_author_email'] ) ? '' : ' checked="checked"';
		$comment_args = array(
			'class_form'           => 'comment-form contact',
			'title_reply'          => esc_html__( 'Leave A Comment', 'kelly-wp' ),
			'title_reply_before'   => '<h2 class="title">',
			'title_reply_after'    => '</h2>',
			'comment_field'        => '<div class="contact-item field-full form-message"><textarea id="comment-content" name="comment"  tabindex="4" class="tb-eff" placeholder="' . esc_attr(esc_html__( 'Comment *', 'kelly-wp' )). '"></textarea></div>',
			'fields'               => apply_filters( 'comment_form_default_fields', array(
				'author' => '<div class="contact-item form-name"><input id="author" name="author" ' . $aria_required . ' tabindex="1" value="' . esc_attr( $current_comment['comment_author'] ) . '" type="text" placeholder="' . esc_attr(esc_html__( 'Name *', 'kelly-wp' )) . '"></div>',
				'email'  => '<div class="contact-item form-email"><input id="email" name="email"  ' . $aria_required . ' tabindex="2" value="' . esc_attr( $current_comment['comment_author_email'] ) . '" type="text" placeholder="' . esc_attr(esc_html__( 'Email *', 'kelly-wp' )) . '"></div>',
				'url'    => '<div class="contact-item form-url"><input id="url" name="url" value="' . esc_attr( $current_comment['comment_author_url'] ) . '" type="text" placeholder="' . esc_attr(esc_html__( 'Website', 'kelly-wp' )) . '"></div>',
				'cookies' => '<p class="comment-form-cookies-consent"><input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes"' . $consent . ' />' .
				             '<label for="wp-comment-cookies-consent">' . esc_html__( 'Save my name, email, and website in this browser for the next time I comment.', 'kelly-wp' ) . '</label></p>',
			) ),
			'comment_notes_after'  => '',
			'comment_notes_before' => '',
			'logged_in_as'         => '<div class="contact-item field-full form-item form-login-logout">' . sprintf( wp_kses(__( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>', 'kelly-wp' ), array(
					'a'      => array(
						'href'  => array(),
						'title' => array()
					),
					'strong' => array()
				) ), esc_url( $edit_link ), $user_identity, esc_url( $logout_link ) ) . '</div>',

			'label_submit' => esc_html__( 'SUBMIT', 'kelly-wp' ),
			'submit_field' => '<div class="contact-item form-submit">%1$s %2$s</div>'
		);
		comment_form( $comment_args, $post_id );
	}
	?>

	<!-- End Respond -->
<?php
