<?php

if ( ! defined( 'ABSPATH' ) ) {
	die( 'You don\'t have sufficient permission to access this page' );
}

require_once( KELLY_DIR . 'core/TGM_Activation_Plugin/class-tgm-plugin-activation.php' );

add_action( 'tgmpa_register', 'kelly_tgm_activation' );

function kelly_tgm_activation () {

	$plugins = array(
		array(
			'name'     => esc_html__( 'Meta Box', 'kelly-wp' ),
			'slug'     => 'meta-box',
			'source'   => esc_url( 'https://wordpress.org/plugins/meta-box/' ),
			'required' => true
		),
		array(
			'name'     => esc_html__( 'Redux Framework', 'kelly-wp' ),
			'slug'     => 'redux-framework',
			'source'   => esc_url( 'https://wordpress.org/plugins/redux-framework/' ),
			'required' => true
		),
		array(
			'name'     => esc_html__( 'Contact Form 7', 'kelly-wp' ),
			'slug'     => 'contact-form-7',
			'source'   => esc_url( 'https://wordpress.org/plugins/contact-form-7/' ),
			'required' => true
		),
		array(
			'name'     => esc_html__( 'KendyThemes Support', 'kelly-wp' ),
			'slug'     => 'kd-support',
			'source'   => KELLY_URI . 'core/TGM_Activation_Plugin/plugins/kd-support.zip',
			'required' => true
		),
	);

	$config = array(
		'default_path' => '',
		'menu'         => 'tgmpa-install-plugins',
		'has_notices'  => true,
		'dismissable'  => false,
		'dismiss_msg'  => false,
		'is_automatic' => true,
		'message'      => '',
		'strings'      => array(
			'page_title'                      => esc_html__( 'Install Required Plugins', 'kelly-wp' ),
			'menu_title'                      => esc_html__( 'Install Plugins', 'kelly-wp' ),
			'installing'                      => esc_html__( 'Installing Plugin: %s', 'kelly-wp' ),
			'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'kelly-wp' ),
			'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'kelly-wp' ),
			// %1$s = plugin name(s).
			'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'kelly-wp' ),
			// %1$s = plugin name(s).
			'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'kelly-wp' ),
			// %1$s = plugin name(s).
			'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'kelly-wp' ),
			// %1$s = plugin name(s).
			'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'kelly-wp' ),
			// %1$s = plugin name(s).
			'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'kelly-wp' ),
			// %1$s = plugin name(s).
			'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'kelly-wp' ),
			// %1$s = plugin name(s).
			'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'kelly-wp' ),
			// %1$s = plugin name(s).
			'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'kelly-wp' ),
			'activate_link'                   => _n_noop( 'Begin activating plugin', 'Begin activating plugins', 'kelly-wp' ),
			'return'                          => esc_html__( 'Return to Required Plugins Installer', 'kelly-wp' ),
			'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'kelly-wp' ),
			'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'kelly-wp' ),
			// %s = dashboard link.
			'nag_type'                        => 'updated'
			// Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
		)
	);
	tgmpa( $plugins, $config );
}