<?php

if ( ! defined( 'ABSPATH' ) ) {
	die( 'You don\'t have sufficient permission to access this page' );
}


class KellyAdminSetup {

	public function __construct () {

		require_once( KELLY_DIR . 'core/TGM_Activation_Plugin/init.php' );
		require_once( KELLY_DIR . 'core/user_settings.php' );
		require_once( KELLY_DIR . 'core/post_settings.php' );
		require_once( KELLY_DIR . 'core/theme_options.php' );
		require_once( KELLY_DIR . 'core/kd-plugins/functions.php' );

		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_assets' ) );
		add_filter( 'wp_head', array( $this, 'overwrite_theme_options' ), '10' );
		add_action( 'project_category_edit_form_fields', array( $this, 'kelly_project_category_add_form_fields' ) );
		add_action( 'edited_project_category', array( $this, 'kelly_edited_project_category' ) );
		add_action( 'manage_edit-project_category_columns', array( $this, 'project_category_columns' ) );
		add_filter('manage_project_category_custom_column', array($this, 'custom_column'), 10, 3);

	}

	public function admin_enqueue_assets () {

		wp_enqueue_style( 'kelly_admin_style', KELLY_URI . 'core/assets/css/style.css', '', null, 'all' );
		wp_enqueue_style( 'wp-color-picker' );

		wp_register_script( 'kelly_admin_script', KELLY_URI . 'core/assets/js/script.js', array(
			'jquery',
			'wp-color-picker'
		), null, true );
		wp_enqueue_script( 'kelly_admin_script' );
		wp_enqueue_media();

	}

	public function overwrite_theme_options () {
		global $post;
		$allow_posts_type = array(
			'post',
			'page',
			'portfolio'
		);
		if ( isset( $post ) && isset( $post->post_type ) && in_array( $post->post_type, $allow_posts_type ) ) {

			global $kelly_options;
			$post_meta = get_post_meta( get_the_ID() );
			$allows    = array(
				'general',
				'profile',
				'post_single',
				'page_single',
				'front-page',
				'project_single'
			);
			foreach ( KellyThemeOptions::config_options() as $id => $section ) {
				if ( in_array( $section['id'], $allows ) ) {
					foreach ( $section['fields'] as $field ) {
						$id_field = $field['id'];
						if ( ! empty( $post_meta[ 'kelly_only_' . $id_field ] ) ) {
							if ( $id_field == 'favicon' || $id_field == 'logo' ) {
								$kelly_options[ $id_field ] = array(
									'id' => $post_meta[ 'kelly_only_' . $id_field ][0]
								);
							} else {
								$kelly_options[ $id_field ] = $post_meta[ 'kelly_only_' . $id_field ][0];
							}
						}
					}
				}
			}
		}
	}

	public function kelly_project_category_add_form_fields ( $term ) {

		$t_id      = $term->term_id;
		$term_meta = get_option( "taxonomy_$t_id" );
		?>
		<tr class="form-field" id="kd-image">
			<th scope="row" valign="top"><label for="term_meta[image]"><?php esc_html_e( 'Image', 'kelly-wp' ); ?></label>
			</th>
			<td>
				<div class="wrap-media">
					<div class="kd-upload" data-parent="#kd-image .kd-img-container" data-multiple="false" data-image-size="kelly_1920x2500">
						<input class="kd-media-value" type="hidden" value="<?php echo esc_attr( $term_meta['image'] ) ? esc_attr( $term_meta['image'] ) : ''; ?>" />
						<input id="term_meta[image]" class="kd-media-value" type="text" name="term_meta[image]" value="<?php echo esc_attr( $term_meta['image'] ) ? esc_attr( $term_meta['image'] ) : ''; ?>" />
						<a href="#" class="button kd-button kd-btn-upload"><?php esc_html_e( 'Image', 'kelly-wp' ); ?></a>
						<div class="kd-img-container">
							<ul class="list-kd-image-media">
								<li class="kd-image">
									<?php
									if ( ! empty( $term_meta['image'] ) ) {
										?>
										<img src="<?php echo esc_url( $term_meta['image'] ); ?>">
										<div class="kd-control-wrap">
											<i class="kd-edit dashicons dashicons-edit"></i><i class="kd-close dashicons dashicons-no-alt"></i>
										</div>
										<?php

									}
									?>

								</li>
							</ul>

						</div>
					</div>
				</div>
			</td>
		</tr>
		<?php
	}

	public function kelly_edited_project_category ( $term_id ) {
		if ( isset( $_POST['term_meta'] ) ) {
			$t_id      = $term_id;
			$term_meta = get_option( "taxonomy_$t_id" );
			$cat_keys  = array_keys( $_POST['term_meta'] );
			foreach ( $cat_keys as $key ) {
				if ( isset ( $_POST['term_meta'][ $key ] ) ) {
					$term_meta[ $key ] = $_POST['term_meta'][ $key ];
				}
			}
			// Save the option array.
			update_option( "taxonomy_$t_id", $term_meta );
		}
	}

	public function project_category_columns ( $columns ) {
		$columns = array_slice( $columns, 0, 2, true ) +
		           array( 'image' => esc_html__( 'Image', 'kelly-wp' ) ) +
		           array_slice( $columns, 2, count( $columns ) - 2, true );

		return $columns;
	}

	public function custom_column($content, $field, $tax_ID ) {
		$meta = get_option("taxonomy_$tax_ID");

		if (!empty($meta['image'])) {
			return '<img src="'. esc_url($meta['image']) .'"/>';
		}
		return $content;
	}


}

new KellyAdminSetup;
