<?php

add_filter( 'kd_support_import_configs', 'kelly_import_configs' );
add_filter( 'kd_after_import_all_done', 'kelly_support_after_import_file' );
add_filter( 'kd_theme_options_name', 'kelly_options_name' );
add_filter( 'kd_support_compile_css', 'kelly_support_compile_css', 10, 2 );
add_filter( 'kd_support_compile_css_file_overwrite', 'kelly_support_compile_css_file_overwrite', 10, 2 );
add_filter( 'kd_support_compile_css_input_file', 'kelly_support_compile_css_input_file', 10, 2 );
add_filter( 'kd_support_compile_css_output_file', 'kelly_support_compile_css_output_file', 10, 2 );
add_filter( 'kelly_main_style_uri', 'kelly_main_style_uri' );


function kelly_import_configs ( $configs ) {
	$new = array(
		'menus'              => array(
			array(
				'menu_name' => 'Kelly Menu',
				'menu_id'   => 'kelly-menu'
			)
		),
		'posts_per_pages'    => '6',
		'theme_options_name' => 'kelly_options',
		'sidebar_widgets' => 'a:4:{s:19:"wp_inactive_widgets";a:0:{}s:17:"kelly-sidebar-1st";a:1:{i:0;s:10:"kd_about-2";}s:17:"kelly-sidebar-2nd";a:1:{i:0;s:12:"kd_contact-2";}s:13:"array_version";i:3;}',
		'theme_option_data' => 'a:60:{s:8:"last_tab";s:0:"";s:9:"preloader";s:1:"1";s:13:"menu_position";s:4:"left";s:7:"favicon";a:5:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";}s:4:"logo";s:5:"Kelly";s:14:"footer_socials";s:1:"1";s:9:"copyright";s:29:"Kelly @ 2018. Design by Kelly";s:18:"header_text_enable";s:1:"0";s:11:"header_text";s:282:"I am a designer with over 5+ years worth of expertise in the UX field. I create seamless end-to-end experiences for desktop, mobile and web application users. My design thinking is rooted in simplicity, which I achieve with user-centric techniques, web standards and best practices.";s:16:"header_text_sign";s:41:"Simplicity is the ultimate sophistication";s:16:"portfolio_layout";s:0:"";s:16:"project_per_page";s:1:"6";s:18:"project_pagination";s:1:"0";s:10:"home_image";s:1:"1";s:9:"home_date";s:1:"1";s:10:"home_views";s:1:"1";s:18:"home_comment_count";s:1:"1";s:14:"home_read_more";s:9:"Read More";s:14:"post_thumbnail";s:1:"1";s:9:"post_date";s:1:"1";s:10:"post_views";s:1:"1";s:18:"post_comment_count";s:1:"1";s:10:"post_share";s:1:"1";s:13:"post_category";s:1:"1";s:9:"post_tags";s:1:"1";s:13:"post_comments";s:1:"1";s:14:"page_thumbnail";s:1:"1";s:9:"page_date";s:1:"1";s:10:"page_views";s:1:"1";s:18:"page_comment_count";s:1:"1";s:10:"page_share";s:1:"1";s:13:"page_comments";s:1:"1";s:7:"behance";s:1:"#";s:8:"dribbble";s:1:"#";s:8:"facebook";s:1:"#";s:6:"flickr";s:1:"#";s:11:"google_plus";s:1:"#";s:9:"instagram";s:1:"#";s:8:"linkedin";s:0:"";s:4:"mail";s:0:"";s:9:"pinterest";s:0:"";s:5:"skype";s:0:"";s:6:"tumblr";s:0:"";s:7:"twitter";s:0:"";s:5:"vimeo";s:0:"";s:9:"vkontakte";s:0:"";s:5:"yahoo";s:0:"";s:7:"youtube";s:0:"";s:9:"404_image";a:5:{s:3:"url";s:62:"http://kelly.kendytheme.net/wp-content/uploads/2018/02/404.jpg";s:2:"id";s:2:"53";s:6:"height";s:3:"397";s:5:"width";s:3:"600";s:9:"thumbnail";s:70:"http://kelly.kendytheme.net/wp-content/uploads/2018/02/404-150x150.jpg";}s:9:"404_title";s:31:"OOP! THIS PAGE CAN NOT BE FOUND";s:13:"404_sub_title";s:49:"Maybe searching or one of the links, can help you";s:15:"body_background";s:7:"#ffffff";s:15:"body_typography";a:6:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:9:"font-size";s:4:"14px";s:11:"line-height";s:4:"24px";s:5:"color";s:7:"#333333";}s:16:"title_typography";a:6:{s:11:"font-family";s:6:"Roboto";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:9:"font-size";s:4:"24px";s:11:"line-height";s:4:"30px";s:5:"color";s:7:"#ababab";}s:15:"menu_typography";a:6:{s:11:"font-family";s:6:"Roboto";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:9:"font-size";s:4:"18px";s:11:"line-height";s:4:"24px";s:5:"color";s:7:"#000000";}s:20:"selection_background";s:7:"#222222";s:15:"selection_color";s:7:"#f7f7f7";s:16:"link_hover_color";s:7:"#000000";s:9:"custom_js";s:0:"";s:10:"custom_css";s:0:"";}',
		'widget_settings' => array(
			'widget_kd_contact' => 'a:2:{i:2;a:4:{s:5:"title";s:10:"Contact Me";s:5:"phone";s:12:"+123 456 789";s:4:"mail";s:24:"kendytheme.ksb@gmail.com";s:8:"location";s:27:"820 Utica Ave, Brooklyn, NY";}s:12:"_multiwidget";i:1;}',
			'widget_kd_about' => 'a:2:{i:2;a:2:{s:5:"title";s:8:"About Me";s:11:"information";s:103:"I am Kelly a Graphic Designer based in New York, specializing in User Interface Design and Development.";}s:12:"_multiwidget";i:1;}'
		)
	);
	return $new;
}

function kelly_support_after_import_file ( $import_done ) {

	return array(
		'kelly_import_demo_done'
	);
}

function kelly_import_demo_done () {
	update_option( 'show_on_front', 'page' );
	update_option( 'page_on_front', 65 );
	update_option( 'page_for_posts', 63 );
	update_option( 'posts_per_page', 6 );
}

function kelly_options_name ( $options_name ) {
	if ( ! empty( $options_name ) ) {
		$options_name = 'kelly_options';
	}

	return $options_name;
}

function kelly_support_compile_css ( $custom_less, $wp_filesystem ) {
	global $kelly_options;

	if ( isset( $kelly_options['body_background'] ) && $kelly_options['body_background'] != '' ) {
		$custom_less .= '@body_background: ' . $kelly_options['body_background'] . '; ' . PHP_EOL;
	}
	if ( isset( $kelly_options['body_typography'] ) ) {
		$body_typo = $kelly_options['body_typography'];

		if ( ! empty( $body_typo['font-family'] ) ) {
			$custom_less .= '@body_font: ' . '"' . $body_typo['font-family'] . '", serif; ' . PHP_EOL;
		}
		if ( ! empty( $body_typo['font-size'] ) ) {
			$custom_less .= '@body_size: ' . absint( $body_typo['font-size'] ) . 'px; ' . PHP_EOL;
		}
		if ( ! empty( $body_typo['line-height'] ) ) {
			$custom_less .= '@body_line_height: ' . absint( $body_typo['line-height'] ) . 'px; ' . PHP_EOL;
		}
		if ( isset( $body_typo['color'] ) && ! empty( $body_typo['color'] ) ) {
			$custom_less .= '@body_color: ' . $body_typo['color'] . '; ' . PHP_EOL;
		}
	}

	if ( isset( $kelly_options['title_typography'] ) ) {
		$title_typo = $kelly_options['title_typography'];

		if ( ! empty( $title_typo['font-family'] ) ) {
			$custom_less .= '@title_font: ' . '"' . $title_typo['font-family'] . '", serif; ' . PHP_EOL;
		}
		if ( ! empty( $title_typo['font-size'] ) ) {
			$custom_less .= '@title_size: ' . absint( $title_typo['font-size'] ) . 'px; ' . PHP_EOL;
		}
		if ( ! empty( $title_typo['line-height'] ) ) {
			$custom_less .= '@title_line_height: ' . absint( $title_typo['line-height'] ) . 'px; ' . PHP_EOL;
		}
		if ( isset( $title_typo['color'] ) && ! empty( $title_typo['color'] ) ) {
			$custom_less .= '@title_color: ' . $title_typo['color'] . '; ' . PHP_EOL;
		}
	}

	if ( isset( $kelly_options['menu_typography'] ) ) {
		$menu_typo = $kelly_options['menu_typography'];

		if ( ! empty( $menu_typo['font-family'] ) ) {
			$custom_less .= '@menu_font: ' . '"' . $menu_typo['font-family'] . '", serif; ' . PHP_EOL;
		}
		if ( isset( $menu_typo['color'] ) && ! empty( $menu_typo['color'] ) ) {
			$custom_less .= '@menu_color: ' . $menu_typo['color'] . '; ' . PHP_EOL;
		}
		if ( isset( $menu_typo['font-size'] ) && ! empty( $menu_typo['font-size'] ) ) {
			$custom_less .= '@menu_size: ' . abs( $menu_typo['font-size'] ) . 'px; ' . PHP_EOL;
		}
		if ( isset( $menu_typo['line-height'] ) && ! empty( $menu_typo['line-height'] ) ) {
			$custom_less .= '@menu_line_height: ' . abs( $menu_typo['line-height'] ) . 'px; ' . PHP_EOL;
		}
	}

	if ( isset( $kelly_options['selection_background'] ) && ! empty( $kelly_options['selection_background'] ) ) {
		$custom_less .= '@selection_background: ' . $kelly_options['selection_background'] . '; ' . PHP_EOL;
	}

	if ( isset( $kelly_options['selection_color'] ) && ! empty( $kelly_options['selection_color'] ) ) {
		$custom_less .= '@selection_color: ' . $kelly_options['selection_color'] . '; ' . PHP_EOL;
	}

	if ( isset( $kelly_options['link_hover_color'] ) && ! empty( $kelly_options['link_hover_color'] ) ) {
		$custom_less .= '@link_hover_color: ' . $kelly_options['link_hover_color'] . '; ' . PHP_EOL;
	}

	return $custom_less;

}

function kelly_support_compile_css_file_overwrite ( $file_overwrite, $wp_filesystem ) {
	return trailingslashit( get_template_directory() ) . 'assets/css/variables.less';
}

function kelly_support_compile_css_input_file ( $compile_input, $wp_filesystem ) {
	return trailingslashit( get_template_directory() ) . 'assets/css/styles.less';
}

function kelly_support_compile_css_output_file ( $compile_output, $wp_filesystem ) {
	return WP_CONTENT_DIR . '/uploads/kelly-styles.css';
}

function kelly_main_style_uri ( $uri ) {

	if ( file_exists( WP_CONTENT_DIR . '/uploads/kelly-styles.css' ) ) {
		$uri = WP_CONTENT_URL . '/uploads/kelly-styles.css';
	}

	return $uri;
}


