<?php
global $Kd_Widgets;

if ( empty( $Kd_Widgets ) || empty( $list_widgets = $Kd_Widgets->widgets_active ) ) {
	return;
}
?>
	<div id="kd-widgets" class="kd-widgets">
		<form action="?page=kd-supports&tab=widgets" method="POST">
			<?php
			$kd_active_widgets = get_option( 'kd_active_widgets' );
			foreach ( $list_widgets as $slug => $widget ) {
				$name = str_replace( '_', ' ', $slug );
				$name = KD_WIDGET_PREFIX . ucwords( $name );
				$check = '';

				if (!empty($kd_active_widgets[$slug]) && $kd_active_widgets[$slug] === 'on') {
					$check = ' checked=checked ';
				}
				?>
				<div class="kd-widget kd-widget-<?php echo esc_attr( $slug ); ?>-wrap">
					<input id="kd-widget-<?php echo esc_attr( $slug ); ?>" type="checkbox" name="kd_active_widgets[<?php echo esc_attr( $slug ); ?>]" <?php echo wp_kses_post($check); ?>>
					<label for="kd-widget-<?php echo esc_attr( $slug ); ?>"><?php echo wp_kses_post($name); ?></label>
				</div>
				<?php
			}
			submit_button();
			?>
		</form>

	</div>
<?php
