<?php
class Kd_Widget_About extends Kd_Widget {

	public $defaults = array(
		'title'       => 'About',
		'image'       => '',
		'name'        => '',
		'link'        => '',
		'information' => '',
		'behance'     => '',
		'dribbble'    => '',
		'facebook'    => '',
		'flickr'      => '',
		'google_plus' => '',
		'instagram'   => '',
		'linkedin'    => '',
		'mail'        => '',
		'pinterest'   => '',
		'skype'       => '',
		'tumblr'      => '',
		'twitter'     => '',
		'vimeo'       => '',
		'vkontakte'   => '',
		'yahoo'       => '',
		'youtube'     => ''
	);

	public function __construct () {
		$widget_ops = array(
			'classname' => 'kd-about',
		);
		parent::__construct( 'kd_about',  esc_html__( 'Kelly About', 'kelly-wp' ), $widget_ops );
	}

	public function form ( $instance ) {

		$instance = array_merge( $this->defaults, $instance );

		$this->kd_item_text( 'title', esc_html__( 'Title', 'kelly-wp' ), 'title', $instance['title'] );
		$this->kd_item_textarea( 'information', esc_html__( 'Information', 'kelly-wp' ), 'information', $instance['information'] );
	}

	public function widget ( $args, $instance ) {
		$title = apply_filters( 'widget_title', $instance['title'] );

		echo wp_kses_post($args['before_widget']);
		if ( ! empty( $title ) ) {
			echo wp_kses_post($args['before_title'] . $title . $args['after_title']);
		}

		?>
		<p class="description">
			<?php echo wp_kses_post( $instance['information'] ); ?>
		</p>
		<?php
		echo wp_kses_post($args['after_widget']);
	}

}

add_action( 'widgets_init', 'kd_register_about' );
function kd_register_about () {
	register_widget( 'Kd_Widget_About' );
}