<?php

class Kd_Widget_Banner extends Kd_Widget {

    public $defaults = array(
        'title' => 'Banner',
        'image' => '',
        'link' => ''
    );

    public function __construct() {
        $widget_ops = array(
            'classname' => 'kd-banner',
        );
        parent::__construct('kd_banner', esc_html__('Kelly Banner', 'kelly-wp'), $widget_ops);
    }

    public function form($instance) {
        $instance = array_merge($this->defaults, $instance);
        $this->kd_item_text('title', esc_html__('Title', 'kelly-wp'), 'title', $instance['title']);
        $this->kd_item_media('image', esc_html__('Image', 'kelly-wp'), 'image', $instance['image'], false, 'large');
        $this->kd_item_text('link', esc_html__('Link', 'kelly-wp'), 'link', $instance['link']);
    }

    public function widget($args, $instance) {
        $title = apply_filters('widget_title', $instance['title']);

        echo wp_kses_post($args['before_widget']);
        if (!empty($title)) {
            echo wp_kses_post($args['before_title'] . $title . $args['after_title']);
        }
        ?>
        <div class="widget-banner-content" style="text-align: center; ">
            <?php
            $before_html = $after_html = '';
            if (!empty($instance['link'])) {
                $before_html = '<a href="'.esc_url($instance['link']).'">';
                $after_html = '</a>';
            }
            echo wp_kses_post($before_html);
            if (!empty($instance['image'])) {
                echo '<img src="'.esc_url($instance['image']).'" alt="'.esc_attr($instance['title']).'">';
            }
            echo wp_kses_post($after_html);
            ?>
        </div>
        <?php
        echo wp_kses_post($args['after_widget']);
    }
}
add_action('widgets_init', 'kd_register_banner');
function kd_register_banner() {
    register_widget('Kd_Widget_Banner');
}