<?php

class Kd_Widget_Contact extends Kd_Widget {

    public $defaults = array(
        'title' => 'Contact Me',
        'location' => '',
        'phone' => '',
        'mail' => ''
    );

    public function __construct() {
        $widget_ops = array(
            'classname' => 'kd-contact',
        );
        parent::__construct('kd_contact', esc_html__('Kelly Contact', 'kelly-wp'), $widget_ops);
    }

    public function form($instance) {
        $instance = array_merge($this->defaults, $instance);
        $this->kd_item_text('title', esc_html__('Title', 'kelly-wp'), 'title', $instance['title']);
        $this->kd_item_text('phone', esc_html__('Phone', 'kelly-wp'), 'phone', $instance['phone']);
        $this->kd_item_text('mail', esc_html__('Mail', 'kelly-wp'), 'mail', $instance['mail']);
	    $this->kd_item_text('location', esc_html__('Location', 'kelly-wp'), 'location', $instance['location']);
    }

    public function widget($args, $instance) {
        $title = apply_filters('widget_title', $instance['title']);

        echo wp_kses_post($args['before_widget']);
        if (!empty($title)) {
            echo wp_kses_post($args['before_title'] . $title . $args['after_title']);
        }
        ?>

	    <ul>
		   <?php
		   if (!empty($instance['phone'])) {
			   ?>
			    <li>
				    <?php esc_html_e('Phone: ', 'kelly-wp'); ?><?php echo wp_kses_post($instance['phone']); ?>
			    </li>
			   <?php
		   }

		   if (!empty($instance['mail'])) {
			   ?>
			   <li>
				   <?php esc_html_e('Email: ', 'kelly-wp'); ?><?php echo wp_kses_post($instance['mail']); ?>
			   </li>
			   <?php
		   }

		   if (!empty($instance['location'])) {
			   ?>
			   <li>
				   <?php esc_html_e('Location: ', 'kelly-wp'); ?><?php echo wp_kses_post($instance['location']); ?>
			   </li>
			   <?php
		   }
		   ?>
	    </ul>
        <?php
        echo wp_kses_post($args['after_widget']);
    }
}
add_action('widgets_init', 'kd_register_contact');
function kd_register_contact() {
    register_widget('Kd_Widget_Contact');
}