<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( 'You don\'t have sufficient permission to access this page' );
}

add_filter( 'rwmb_meta_boxes', 'kelly_settings_only_post' );

function kelly_settings_only_post ( $meta_boxes ) {
	$prefix = 'kelly_only_';

	$meta_boxes[] = array(
		'id'         => 'kelly_post',
		'title'      => esc_html__( 'Additional Settings', 'kelly-wp' ),
		'post_types' => array( 'post' ),
		'context'    => 'normal',
		'priority'   => 'high',
		'autosave'   => true,
		'fields'     => array(

			/* The excerpt */
			array(
				'type' => 'heading',
				'name' => esc_html__( 'The Excerpt', 'kelly-wp' ),
				'desc' => esc_html__( 'Display a summary of the content', 'kelly-wp' ),
			),
			array(
				'type' => 'textarea',
				'id' => 'kd_excerpt',
				'name' => esc_html__('The Excerpt', 'kelly-wp'),
				'std' => '',
				'before' => '<div class="kd-excerpt">',
				'after' => '</div>'
			),

			/* Single Settings */
			array(
				'type' => 'heading',
				'name' => esc_html__( 'Single', 'kelly-wp' ),
				'desc' => esc_html__( 'Overwrite settings in Dashboard > Theme Options > Post Single', 'kelly-wp' ),
			),
			array(
				'name'        => esc_html__( 'Post Thumbnail', 'kelly-wp' ),
				'id'          => $prefix . 'post_thumbnail',
				'type'        => 'select',
				'options'     => array(
					'1' => esc_html__( 'Display', 'kelly-wp' ),
					'0' => esc_html__( 'Hide', 'kelly-wp' ),
				),
				'multiple'    => false,
				'std'         => '',
				'placeholder' => esc_html__( 'Theme Options', 'kelly-wp' ),
			),
			array(
				'name'        => esc_html__( 'Post Date', 'kelly-wp' ),
				'id'          => $prefix . 'post_date',
				'type'        => 'select',
				'options'     => array(
					'1' => esc_html__( 'Display', 'kelly-wp' ),
					'0' => esc_html__( 'Hide', 'kelly-wp' ),
				),
				'multiple'    => false,
				'std'         => '',
				'placeholder' => esc_html__( 'Theme Options', 'kelly-wp' ),
			),
			array(
				'name'        => esc_html__( 'Post Views', 'kelly-wp' ),
				'id'          => $prefix . 'post_views',
				'type'        => 'select',
				'options'     => array(
					'1' => esc_html__( 'Display', 'kelly-wp' ),
					'0' => esc_html__( 'Hide', 'kelly-wp' ),
				),
				'multiple'    => false,
				'std'         => '',
				'placeholder' => esc_html__( 'Theme Options', 'kelly-wp' ),
			),
			array(
				'name'        => esc_html__( 'Post Comment Count', 'kelly-wp' ),
				'id'          => $prefix . 'post_comment_count',
				'type'        => 'select',
				'options'     => array(
					'1' => esc_html__( 'Display', 'kelly-wp' ),
					'0' => esc_html__( 'Hide', 'kelly-wp' ),
				),
				'multiple'    => false,
				'std'         => '',
				'placeholder' => esc_html__( 'Theme Options', 'kelly-wp' ),
			),
			array(
				'name'        => esc_html__( 'Post Share', 'kelly-wp' ),
				'id'          => $prefix . 'post_share',
				'type'        => 'select',
				'options'     => array(
					'1' => esc_html__( 'Display', 'kelly-wp' ),
					'0' => esc_html__( 'Hide', 'kelly-wp' ),
				),
				'multiple'    => false,
				'std'         => '',
				'placeholder' => esc_html__( 'Theme Options', 'kelly-wp' ),
			),
			array(
				'name'        => esc_html__( 'Post Category', 'kelly-wp' ),
				'id'          => $prefix . 'post_category',
				'type'        => 'select',
				'options'     => array(
					'1' => esc_html__( 'Display', 'kelly-wp' ),
					'0' => esc_html__( 'Hide', 'kelly-wp' ),
				),
				'multiple'    => false,
				'std'         => '',
				'placeholder' => esc_html__( 'Theme Options', 'kelly-wp' ),
			),
			array(
				'name'        => esc_html__( 'Post Tags', 'kelly-wp' ),
				'id'          => $prefix . 'post_tags',
				'type'        => 'select',
				'options'     => array(
					'1' => esc_html__( 'Display', 'kelly-wp' ),
					'0' => esc_html__( 'Hide', 'kelly-wp' ),
				),
				'multiple'    => false,
				'std'         => '',
				'placeholder' => esc_html__( 'Theme Options', 'kelly-wp' ),
			),
			array(
				'name'        => esc_html__( 'Post Comments', 'kelly-wp' ),
				'id'          => $prefix . 'post_comments',
				'type'        => 'select',
				'options'     => array(
					'1' => esc_html__( 'Display', 'kelly-wp' ),
					'0' => esc_html__( 'Hide', 'kelly-wp' ),
				),
				'multiple'    => false,
				'std'         => '',
				'placeholder' => esc_html__( 'Theme Options', 'kelly-wp' ),
			)
		)
	);

	$meta_boxes[] = array(
		'id'         => 'kelly_post',
		'title'      => esc_html__( 'Additional Settings', 'kelly-wp' ),
		'post_types' => array( 'page' ),
		'context'    => 'normal',
		'priority'   => 'high',
		'autosave'   => true,
		'fields'     => array(

			/* Single Settings */
			array(
				'type' => 'heading',
				'name' => esc_html__( 'Page Single', 'kelly-wp' ),
				'desc' => esc_html__( 'Overwrite settings in Dashboard > Theme Options > Page Single', 'kelly-wp' ),
			),
			array(
				'name'        => esc_html__( 'Page Thumbnail', 'kelly-wp' ),
				'id'          => $prefix . 'page_thumbnail',
				'type'        => 'select',
				'options'     => array(
					'1' => esc_html__( 'Display', 'kelly-wp' ),
					'0' => esc_html__( 'Hide', 'kelly-wp' ),
				),
				'multiple'    => false,
				'std'         => '',
				'placeholder' => esc_html__( 'Theme Options', 'kelly-wp' ),
			),
			array(
				'name'        => esc_html__( 'Page Date', 'kelly-wp' ),
				'id'          => $prefix . 'page_date',
				'type'        => 'select',
				'options'     => array(
					'1' => esc_html__( 'Display', 'kelly-wp' ),
					'0' => esc_html__( 'Hide', 'kelly-wp' ),
				),
				'multiple'    => false,
				'std'         => '',
				'placeholder' => esc_html__( 'Theme Options', 'kelly-wp' ),
			),
			array(
				'name'        => esc_html__( 'Page Views', 'kelly-wp' ),
				'id'          => $prefix . 'page_views',
				'type'        => 'select',
				'options'     => array(
					'1' => esc_html__( 'Display', 'kelly-wp' ),
					'0' => esc_html__( 'Hide', 'kelly-wp' ),
				),
				'multiple'    => false,
				'std'         => '',
				'placeholder' => esc_html__( 'Theme Options', 'kelly-wp' ),
			),
			array(
				'name'        => esc_html__( 'Page Comment Count', 'kelly-wp' ),
				'id'          => $prefix . 'page_comment_count',
				'type'        => 'select',
				'options'     => array(
					'1' => esc_html__( 'Display', 'kelly-wp' ),
					'0' => esc_html__( 'Hide', 'kelly-wp' ),
				),
				'multiple'    => false,
				'std'         => '',
				'placeholder' => esc_html__( 'Theme Options', 'kelly-wp' ),
			),
			array(
				'name'        => esc_html__( 'Page Share', 'kelly-wp' ),
				'id'          => $prefix . 'page_share',
				'type'        => 'select',
				'options'     => array(
					'1' => esc_html__( 'Display', 'kelly-wp' ),
					'0' => esc_html__( 'Hide', 'kelly-wp' ),
				),
				'multiple'    => false,
				'std'         => '',
				'placeholder' => esc_html__( 'Theme Options', 'kelly-wp' ),
			),
			array(
				'name'        => esc_html__( 'Page Comments', 'kelly-wp' ),
				'id'          => $prefix . 'page_comments',
				'type'        => 'select',
				'options'     => array(
					'1' => esc_html__( 'Display', 'kelly-wp' ),
					'0' => esc_html__( 'Hide', 'kelly-wp' ),
				),
				'multiple'    => false,
				'std'         => '',
				'placeholder' => esc_html__( 'Theme Options', 'kelly-wp' ),
			)
		)
	);

	$meta_boxes[] = array(
		'id'         => 'kelly_project',
		'title'      => esc_html__( 'Additional Settings', 'kelly-wp' ),
		'post_types' => array( 'portfolio' ),
		'context'    => 'normal',
		'priority'   => 'high',
		'autosave'   => true,
		'fields' => array(
			array(
				'type' => 'heading',
				'name' => esc_html__( 'Project Settings', 'kelly-wp' ),
				'desc' => esc_html__( 'More information about this project: Date, Client, Images', 'kelly-wp' ),
			),
			array(
				'name'        => esc_html__( 'Pictures', 'kelly-wp' ),
				'id'          => $prefix . 'images',
				'type'        => 'image_advanced',
				'std' => '',
			),
			array(
				'type' => 'text',
				'id' => $prefix. 'client',
				'name' => esc_html__('Client', 'kelly-wp'),
				'std' => '',
			),
			array(
				'type' => 'text',
				'id' => $prefix. 'client_url',
				'name' => esc_html__('Client URL', 'kelly-wp'),
				'std' => '',
			),
			array(
				'type' => 'text',
				'id' => $prefix. 'date',
				'name' => esc_html__('Date', 'kelly-wp'),
				'std' => '',
			),
			array(
				'type' => 'text',
				'id' => $prefix. 'location',
				'name' => esc_html__('Location', 'kelly-wp'),
				'std' => '',
			),
			array(
				'type' => 'text',
				'id' => $prefix. 'budget',
				'name' => esc_html__('Budget', 'kelly-wp'),
				'std' => '',
			),
			array(
				'name'        => esc_html__( 'Share Project Buttons', 'kelly-wp' ),
				'id'          => $prefix . 'share',
				'type'        => 'select',
				'options'     => array(
					'not_share' => esc_html__( 'Not Share', 'kelly-wp' ),
				),
				'multiple'    => false,
				'std'         => 'share',
				'placeholder' => esc_html__( 'Share', 'kelly-wp' )
			)
		)
	);

	return $meta_boxes;
}