<?php

if ( ! defined( 'ABSPATH' ) ) {
	die( 'You don\'t have sufficient permission to access this page' );
}

class KellyThemeOptions {

	public $options_name = 'kelly_options';

	public static function get_all_pages () {
		$page_ids = get_all_page_ids();
		$output   = array();

		foreach ( $page_ids as $page ) {
			$output[ $page ] = get_the_title( $page );
		}

		return $output;
	}

	public static function get_all_contact_form () {
		$arg_query    = array(
			'post_type'           => 'wpcf7_contact_form',
			'ignore_sticky_posts' => false,
			'posts_per_page'      => '-1',
			'post_status'         => 'publish'
		);
		$custom_query = new WP_Query( $arg_query );
		$output       = array();
		if ( $custom_query->have_posts() ) {
			while ( $custom_query->have_posts() ) {
				$custom_query->the_post();
				$output[ get_the_ID() ] = get_the_title();
			}
			wp_reset_postdata();
		}

		return $output;
	}

	public static function config_options () {

		$all_options = array(

			array(
				'title'  => esc_html__( 'General', 'kelly-wp' ),
				'id'     => 'general',
				'icon'   => 'dashicons dashicons-admin-generic',
				'fields' => array(

					array(
						'id'      => 'preloader',
						'type'    => 'switch',
						'default' => '1',
						'title'   => esc_html__( 'Preload', 'kelly-wp' ),
					),

					array(
						'id'      => 'retina',
						'type'    => 'switch',
						'default' => '0',
						'title'   => esc_html__( 'Use Retina', 'kelly-wp' ),
					),

					array(
						'id'      => 'menu_position',
						'type'    => 'select',
						'title'   => esc_html__( 'Menu Position', 'kelly-wp' ),
						'options' => array(
							'left'      => esc_html__( 'Menu Left', 'kelly-wp' ),
							'right'            => esc_html__( 'Menu Right', 'kelly-wp' )
						),
						'default' => 'left'
					),

					/* Start Header Settings */
					array(
						'id'     => 'header_open',
						'type'   => 'section',
						'title'  => esc_html__( 'Header Settings', 'kelly-wp' ),
						'indent' => true
					),
					array(
						'id'       => 'favicon',
						'type'     => 'media',
						'title'    => esc_html__( 'Favicon', 'kelly-wp' ),
						'subtitle' => esc_html__( 'Just the small sizes 32x32px are appearing when you upload', 'kelly-wp' ),
						'default'  => array(
							'id'  => '',
							'src' => ''
						)
					),

					array(
						'id'       => 'logo_media',
						'type'     => 'media',
						'title'    => esc_html__( 'Logo Media', 'kelly-wp' ),
						'default'  => array(
							'id'  => '',
							'src' => ''
						)
					),
					array(
						'id'       => 'logo_media_mobile',
						'type'     => 'media',
						'title'    => esc_html__( 'Logo Media Mobile', 'kelly-wp' ),
						'description' => esc_html__(' Only working when you setup Logo Media', 'kelly-wp'),
						'default'  => array(
							'id'  => '',
							'src' => ''
						)
					),
					array(
						'id'       => 'logo',
						'type'     => 'text',
						'title'    => esc_html__( 'Logo Text', 'kelly-wp' ),
						'description' => esc_html__('If you don\'t wanna use Logo Media, this is the simplest way. Only working when Logo Media is empty', 'kelly-wp'),
						'default'  => 'Kelly'
					),
					array(
						'id'     => 'header_close',
						'type'   => 'section',
						'indent' => false,
					),
					/* End Header Settings */

					/* Footer Settings */
					array(
						'id'     => 'footer_open',
						'type'   => 'section',
						'title'  => esc_html__( 'Footer Settings', 'kelly-wp' ),
						'indent' => true
					),

					array(
						'id'      => 'footer_socials',
						'type'    => 'switch',
						'title'   => esc_html__( 'Socials', 'kelly-wp' ),
						'default' => '0'
					),
					array(
						'id'      => 'copyright',
						'type'    => 'textarea',
						'title'   => esc_html__( 'Copyright', 'kelly-wp' ),
						'default' => 'Kelly @ 2018. Design by Kelly',
					),
					array(
						'id'     => 'footer_close',
						'type'   => 'section',
						'indent' => false,
					),
					/* Footer Settings */
				)
			),
			array(
				'title'  => esc_html__( 'Projects Page', 'kelly-wp' ),
				'id'     => 'front-page',
				'icon'   => 'dashicons dashicons-admin-home',
				'fields' => array(
					array(
						'id'      => 'header_text_enable',
						'type'    => 'switch',
						'title'   => esc_html__( 'Header Enable', 'kelly-wp' ),
						'default' => '1'
					),
					array(
						'id'      => 'header_text_home',
						'type'    => 'switch',
						'title'   => esc_html__( 'Home Page', 'kelly-wp' ),
						'default' => '1',
						'required' => array('header_text_enable','equals','1')
					),
					array(
						'id'      => 'header_text_blog',
						'type'    => 'switch',
						'title'   => esc_html__( 'Posts Page', 'kelly-wp' ),
						'default' => '1',
						'required' => array('header_text_enable','equals','1')
					),
					array(
						'id'      => 'header_text_post',
						'type'    => 'switch',
						'title'   => esc_html__( 'Single Post', 'kelly-wp' ),
						'default' => '1',
						'required' => array('header_text_enable','equals','1')
					),
					array(
						'id'      => 'header_text_page',
						'type'    => 'switch',
						'title'   => esc_html__( 'Single Page', 'kelly-wp' ),
						'default' => '1',
						'required' => array('header_text_enable','equals','1')
					),
					array(
						'id'      => 'header_text_project',
						'type'    => 'switch',
						'title'   => esc_html__( 'Single Project', 'kelly-wp' ),
						'default' => '1',
						'required' => array('header_text_enable','equals','1')
					),
					array(
						'id'      => 'header_text_project_category',
						'type'    => 'switch',
						'title'   => esc_html__( 'Category Projects', 'kelly-wp' ),
						'default' => '1',
						'required' => array('header_text_enable','equals','1')
					),
					array(
						'id'      => 'header_text_category',
						'type'    => 'switch',
						'title'   => esc_html__( 'Category Posts', 'kelly-wp' ),
						'default' => '1',
						'required' => array('header_text_enable','equals','1')
					),
					array(
						'id'      => 'header_text_tags',
						'type'    => 'switch',
						'title'   => esc_html__( 'Tags Posts', 'kelly-wp' ),
						'default' => '1',
						'required' => array('header_text_enable','equals','1')
					),
					array(
						'id' => 'header_text',
						'type' => 'textarea',
						'title' => esc_html__('Header Text', 'kelly-wp'),
						'default' => 'I am a designer with over 5+ years worth of expertise in the UX field. I create seamless end-to-end experiences for desktop, mobile and web application users. My design thinking is rooted in simplicity, which I achieve with user-centric techniques, web standards and best practices.',
						'description' => esc_html__('Support tags: ', 'kelly-wp') . 'strong, span, b, i, u, etc'
					),
					array(
						'id' => 'header_text_sign',
						'type' => 'text',
						'title' => esc_html__('Header Sign', 'kelly-wp'),
						'default' => 'Simplicity is the ultimate sophistication'
					),
					array(
						'id'      => 'portfolio_layout',
						'type'    => 'select',
						'title'   => esc_html__( 'Layout', 'kelly-wp' ),
						'options' => array(
							'list'            => esc_html__( 'List', 'kelly-wp' ),
							'tiled-gallery'      => esc_html__( 'Tiled', 'kelly-wp' )
						),
						'default' => 'tiled'
					),
					array(
						'id'      => 'project_lightbox',
						'type'    => 'switch',
						'title'   => esc_html__( 'Lightbox', 'kelly-wp' ),
						'default' => '0'
					),
					array(
						'id'      => 'project_per_page',
						'type'    => 'text',
						'title'   => esc_html__( 'Home pages show at most', 'kelly-wp' ),
						'description' => esc_html__('projects', 'kelly-wp'),
						'default' => '6'
					),
					array(
						'id'      => 'project_pagination',
						'type'    => 'switch',
						'title'   => esc_html__( 'Pagination', 'kelly-wp' ),
						'default' => '0'
					)
				)
			),

			array(
				'title'  => esc_html__( 'Blog', 'kelly-wp' ),
				'id'     => 'posts_page',
				'icon'   => 'dashicons dashicons-schedule',
				'fields' => array(
					array(
						'id'      => 'home_image',
						'type'    => 'switch',
						'title'   => esc_html__( 'Post Thumbnail', 'kelly-wp' ),
						'default' => '1'
					),
					array(
						'id'      => 'home_date',
						'type'    => 'switch',
						'title'   => esc_html__( 'Post Date', 'kelly-wp' ),
						'default' => '1'
					),
					array(
						'id'      => 'home_views',
						'type'    => 'switch',
						'title'   => esc_html__( 'Post Views', 'kelly-wp' ),
						'default' => '0'
					),
					array(
						'id'      => 'home_comment_count',
						'type'    => 'switch',
						'title'   => esc_html__( 'Comment Count', 'kelly-wp' ),
						'default' => '1'
					),
					array(
						'id'      => 'home_read_more',
						'type'    => 'text',
						'title'   => esc_html__( 'Read More', 'kelly-wp' ),
						'default' => 'Read More'
					)
				)
			),
			array(
				'title'  => esc_html__( 'Post Single', 'kelly-wp' ),
				'id'     => 'post_single',
				'icon'   => 'dashicons dashicons-welcome-write-blog',
				'fields' => array(
					array(
						'id'      => 'post_thumbnail',
						'type'    => 'switch',
						'title'   => esc_html__( 'Post Thumbnail', 'kelly-wp' ),
						'default' => '1'
					),
					array(
						'id'      => 'post_date',
						'type'    => 'switch',
						'title'   => esc_html__( 'Post Date', 'kelly-wp' ),
						'default' => '1'
					),
					array(
						'id'      => 'post_views',
						'type'    => 'switch',
						'title'   => esc_html__( 'Post Views', 'kelly-wp' ),
						'default' => '0'
					),
					array(
						'id'      => 'post_comment_count',
						'type'    => 'switch',
						'title'   => esc_html__( 'Comment Count', 'kelly-wp' ),
						'default' => '1'
					),
					array(
						'id'      => 'post_share',
						'type'    => 'switch',
						'title'   => esc_html__( 'Share', 'kelly-wp' ),
						'default' => '1'
					),
					array(
						'id'      => 'post_category',
						'type'    => 'switch',
						'title'   => esc_html__( 'Category', 'kelly-wp' ),
						'default' => '1'
					),
					array(
						'id'      => 'post_tags',
						'type'    => 'switch',
						'title'   => esc_html__( 'Tags', 'kelly-wp' ),
						'default' => '1'
					),
					array(
						'id'      => 'post_navigation',
						'type'    => 'switch',
						'title'   => esc_html__( 'Next & Previous Post', 'kelly-wp' ),
						'default' => '1'
					),
					array(
						'id'      => 'post_comments',
						'type'    => 'switch',
						'title'   => esc_html__( 'Comments', 'kelly-wp' ),
						'default' => '1'
					)
				)
			),
			array(
				'title'  => esc_html__( 'Page Single', 'kelly-wp' ),
				'id'     => 'page_single',
				'icon'   => 'dashicons dashicons-welcome-widgets-menus',
				'fields' => array(
					array(
						'id'      => 'page_thumbnail',
						'type'    => 'switch',
						'title'   => esc_html__( 'Page Thumbnail', 'kelly-wp' ),
						'default' => '1'
					),
					array(
						'id'      => 'page_date',
						'type'    => 'switch',
						'title'   => esc_html__( 'Page Date', 'kelly-wp' ),
						'default' => '1'
					),
					array(
						'id'      => 'page_views',
						'type'    => 'switch',
						'title'   => esc_html__( 'Page Views', 'kelly-wp' ),
						'default' => '0'
					),
					array(
						'id'      => 'page_comment_count',
						'type'    => 'switch',
						'title'   => esc_html__( 'Comment Count', 'kelly-wp' ),
						'default' => '1'
					),
					array(
						'id'      => 'page_share',
						'type'    => 'switch',
						'title'   => esc_html__( 'Share', 'kelly-wp' ),
						'default' => '1'
					),
					array(
						'id'      => 'page_comments',
						'type'    => 'switch',
						'title'   => esc_html__( 'Comments', 'kelly-wp' ),
						'default' => '1'
					)
				)
			),
			array(
				'title'  => esc_html__( 'Socials', 'kelly-wp' ),
				'id'     => 'socials',
				'icon'   => 'dashicons dashicons-share',
				'fields' => array(
					array(
						'id'      => 'behance',
						'type'    => 'text',
						'title'   => esc_html__( 'Behance', 'kelly-wp' ),
						'default' => '#',
					),
					array(
						'id'      => 'dribbble',
						'type'    => 'text',
						'title'   => esc_html__( 'Dribbble', 'kelly-wp' ),
						'default' => '#',
					),
					array(
						'id'      => 'facebook',
						'type'    => 'text',
						'title'   => esc_html__( 'Facebook', 'kelly-wp' ),
						'default' => '#',
					),
					array(
						'id'      => 'flickr',
						'type'    => 'text',
						'title'   => esc_html__( 'Flickr', 'kelly-wp' ),
						'default' => '#',
					),
					array(
						'id'      => 'google_plus',
						'type'    => 'text',
						'title'   => esc_html__( 'Google Plus', 'kelly-wp' ),
						'default' => '#',
					),
					array(
						'id'      => 'instagram',
						'type'    => 'text',
						'title'   => esc_html__( 'Instagram', 'kelly-wp' ),
						'default' => '#',
					),
					array(
						'id'      => 'linkedin',
						'type'    => 'text',
						'title'   => esc_html__( 'Linkedin', 'kelly-wp' ),
						'default' => '',
					),
					array(
						'id'      => 'mail',
						'type'    => 'text',
						'title'   => esc_html__( 'Mail', 'kelly-wp' ),
						'default' => '',
					),
					array(
						'id'      => 'pinterest',
						'type'    => 'text',
						'title'   => esc_html__( 'Pinterest', 'kelly-wp' ),
						'default' => '',
					),
					array(
						'id'      => 'rss',
						'type'    => 'text',
						'title'   => esc_html__( 'RSS', 'kelly-wp' ),
						'default' => '',
					),
					array(
						'id'      => 'skype',
						'type'    => 'text',
						'title'   => esc_html__( 'Skype', 'kelly-wp' ),
						'default' => '',
					),
					array(
						'id'      => 'tumblr',
						'type'    => 'text',
						'title'   => esc_html__( 'Tumblr', 'kelly-wp' ),
						'default' => '',
					),
					array(
						'id'      => 'twitter',
						'type'    => 'text',
						'title'   => esc_html__( 'Twitter', 'kelly-wp' ),
						'default' => '',
					),
					array(
						'id'      => 'vimeo',
						'type'    => 'text',
						'title'   => esc_html__( 'Vimeo', 'kelly-wp' ),
						'default' => '',
					),
					array(
						'id'      => 'vkontakte',
						'type'    => 'text',
						'title'   => esc_html__( 'VKontakte', 'kelly-wp' ),
						'default' => '',
					),
					array(
						'id'      => 'yahoo',
						'type'    => 'text',
						'title'   => esc_html__( 'Yahoo', 'kelly-wp' ),
						'default' => '',
					),
					array(
						'id'      => 'youtube',
						'type'    => 'text',
						'title'   => esc_html__( 'Youtube', 'kelly-wp' ),
						'default' => '',
					),

				),

			),
			array(
				'title'  => esc_html__( '404', 'kelly-wp' ),
				'id'     => '404 Page',
				'icon'   => 'dashicons dashicons-dismiss',
				'fields' => array(
					array(
						'id'      => '404_image',
						'type'    => 'media',
						'title'   => esc_html__( 'Image', 'kelly-wp' ),
						'default' => array(
							'id'  => '',
							'src' => KELLY_URI . 'assets/images/404.jpg'
						)
					),
					array(
						'id'      => '404_title',
						'type'    => 'text',
						'title'   => esc_html__( 'Title', 'kelly-wp' ),
						'default' => 'OOPS! THIS PAGE CAN NOT BE FOUND',
					),
					array(
						'id'      => '404_sub_title',
						'type'    => 'text',
						'title'   => esc_html__( 'Sub title 1', 'kelly-wp' ),
						'default' => 'Maybe searching or one of the links, can help you',
					)
				)
			)
		);

		if ( class_exists( 'Kd_Support' ) ) {
			$desc = esc_html__( 'This section only work when the <code>KendyTheme Support Plugin</code> is activated.', 'kelly-wp' );

			$file       = KELLY_DIR . 'assets/css/variables.less';
			$permission = self::permission( $file );

			if ( ! empty( $permission ) ) {

				$desc .= sprintf( esc_html__( '<p class="notice notice-error">Please set the permission to write with the file <code>%s</code> (recommended 0766 or 0777)</p>', 'kelly-wp' ), $file );
			}
			$all_options[] = array(
				'title'  => esc_html__( 'Advance', 'kelly-wp' ),
				'desc'   => $desc,
				'id'     => 'advance',
				'icon'   => 'dashicons dashicons-admin-tools',
				'fields' => array(

					/* Typo Body */
					array(
						'id'          => 'body_background',
						'type'        => 'color',
						'title'       => esc_html__( 'Body Background', 'kelly-wp' ),
						'default'     => '#ffffff',
						'transparent' => false
					),
					array(
						'id'           => 'body_typography',
						'type'         => 'typography',
						'title'        => esc_html__( 'Body Font', 'kelly-wp' ),
						'google'       => true,
						'font-backup'  => false,
						'line-height'  => true,
						'text-align'   => false,
						'color'        => true,
						'font-size'    => true,
						'font-style'   => false,
						'font-weight'  => false,
						'word-spacing' => false,
						'subsets'      => false,
						'default'      => array(
							'font-family' => 'Lato',
							'font-size'   => '14',
							'line-height'   => '24',
							'color'       => '#333333',
							'google'      => true
						)
					),

					/* Typo Title */
					array(
						'id'           => 'title_typography',
						'type'         => 'typography',
						'title'        => esc_html__( 'Title Font', 'kelly-wp' ),
						'google'       => true,
						'font-backup'  => false,
						'line-height'  => true,
						'text-align'   => false,
						'color'        => true,
						'font-size'    => true,
						'font-style'   => false,
						'font-weight'  => false,
						'word-spacing' => false,
						'subsets'      => false,
						'default'      => array(
							'font-family' => 'Roboto',
							'font-size'   => '24',
							'line-height' => '30',
							'color'       => '#ababab',
						)
					),

					/* Typo Menu Font*/
					array(
						'id'           => 'menu_typography',
						'type'         => 'typography',
						'title'        => esc_html__( 'Menu Font', 'kelly-wp' ),
						'google'       => true,
						'font-backup'  => false,
						'line-height'  => true,
						'text-align'   => false,
						'color'        => true,
						'font-size'    => true,
						'font-style'   => false,
						'font-weight'  => false,
						'word-spacing' => false,
						'subsets'      => false,
						'default'      => array(
							'font-family' => 'Roboto',
							'font-size'   => '18',
							'line-height' => '24',
							'color'       => '#000000',
							'google'      => true
						)
					),


					/* Typo Selection */
					array(
						'id'          => 'selection_background',
						'type'        => 'color',
						'title'       => esc_html__( 'Selection Background', 'kelly-wp' ),
						'default'     => '#222222',
						'transparent' => false
					),
					array(
						'id'          => 'selection_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Selection Color', 'kelly-wp' ),
						'default'     => '#f7f7f7',
						'transparent' => false
					),
					array(
						'id'          => 'link_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Link Hover Color', 'kelly-wp' ),
						'default'     => '#000000',
						'transparent' => false
					),
					array(
						'id'      => 'custom_css',
						'type'    => 'ace_editor',
						'title'   => esc_html__( 'Custom CSS', 'kelly-wp' ),
						'mode'    => 'css',
						'theme'   => 'monokai',
						'default' => ''
					)
				)
			);
		}

		return $all_options;
	}

	public static function permission ( $file = '' ) {

		if ( ! file_exists( $file ) ) {
			return false;
		}
		if ( is_writable( $file ) ) {
			return false;
		}

		$permission = substr( decoct( fileperms( $file ) ), 2 );

		return $permission;

	}

	public function __construct () {

		$this->kd_configs();
		$this->kd_list_tags();
	}

	public static function kd_list_category () {

		$categories = get_categories();
		$output     = array();

		foreach ( $categories as $cat ) {
			$output[ $cat->slug ] = $cat->name;
		}

		return $output;
	}

	public static function kd_list_tags () {

		$tags = get_tags();

		$output = array();

		foreach ( $tags as $tag ) {
			$output[ $tag->slug ] = $tag->name;
		}

		return $output;
	}

	public function kd_configs () {

		Redux::setArgs(
			$this->options_name,
			array(
				'opt_name'            => $this->options_name,
				'display_name'        => esc_html__( 'Theme Options', 'kelly-wp' ),
				'display_version'     => '1.0',
				'menu_type'           => 'menu',
				'menu_title'          => esc_html__( 'Theme Options', 'kelly-wp' ),
				'page_slug'           => 'kelly-options',
				'page_title'          => esc_html__( 'Theme Options', 'kelly-wp' ),
				'allow_sub_menu'      => true,
				'admin_bar'           => true,
				'admin_bar_icon'      => 'dashicons-portfolio',
				'admin_bar_priority'  => 50,
				'show_options_object' => false,

			)
		);

		$config = $this->config_options();

		foreach ( $config as $section ) {
			Redux::setSection( $this->options_name, $section );
		}
	}
}

if ( ! class_exists( 'Redux' ) ) {
	return;
}
new KellyThemeOptions;

