<?php


if ( ! defined( 'ABSPATH' ) ) {
	die( 'You don\'t have sufficient permission to access this page' );
}


class KellyUserSettings {

	public $user_custom;

	public function default_settings () {

		/* Type : text, textarea, spectrum, media */
		return array(
			'facebook'    => array(
				'type'  => 'text',
				'title' => esc_html__( 'Facebook', 'kelly-wp' ),
				'value' => 'https://www.facebook.com/'
			),
			'behance'     => array(
				'type'  => 'text',
				'title' => esc_html__( 'Behance', 'kelly-wp' ),
				'value' => 'https://www.behance.net/'
			),
			'dribbble'    => array(
				'type'  => 'text',
				'title' => esc_html__( 'Dribbble', 'kelly-wp' ),
				'value' => ''
			),
			'flickr'      => array(
				'type'  => 'text',
				'title' => esc_html__( 'Flickr', 'kelly-wp' ),
				'value' => 'https://plus.google.com/'
			),
			'google_plus' => array(
				'type'  => 'text',
				'title' => esc_html__( 'Google Plus', 'kelly-wp' ),
				'value' => ''
			),
			'instagram'   => array(
				'type'  => 'text',
				'title' => esc_html__( 'Instagram', 'kelly-wp' ),
				'value' => ''
			),
			'linkedin'    => array(
				'type'  => 'text',
				'title' => esc_html__( 'Linkedin', 'kelly-wp' ),
				'value' => ''
			),
			'mail'        => array(
				'type'  => 'text',
				'title' => esc_html__( 'Mail', 'kelly-wp' ),
				'value' => ''
			),
			'pinterest'   => array(
				'type'  => 'text',
				'title' => esc_html__( 'Pinterest', 'kelly-wp' ),
				'value' => ''
			),
			'skype'       => array(
				'type'  => 'text',
				'title' => esc_html__( 'Skype', 'kelly-wp' ),
				'value' => ''
			),
			'tumblr'      => array(
				'type'  => 'text',
				'title' => esc_html__( 'Tumblr', 'kelly-wp' ),
				'value' => ''
			),
			'twitter'     => array(
				'type'  => 'text',
				'title' => esc_html__( 'Twitter', 'kelly-wp' ),
				'value' => 'http://twitter.com/'
			),
			'vimeo'       => array(
				'type'  => 'text',
				'title' => esc_html__( 'Vimeo', 'kelly-wp' ),
				'value' => ''
			),
			'vkontakte' => array(
				'type'  => 'text',
				'title' => esc_html__( 'Vkontakte', 'kelly-wp' ),
				'value' => ''
			),
			'yahoo'       => array(
				'type'  => 'text',
				'title' => esc_html__( 'Yahoo', 'kelly-wp' ),
				'value' => ''
			),
			'avatar'       => array(
				'type'  => 'media',
				'title' => esc_html__( 'Avatar', 'kelly-wp' ),
				'desc' => esc_html__('Recommend you should use the picture with size 300x300 px', 'kelly-wp'),
				'value' => '',
				'image_size' => 'thumbnail'
			)
		);
	}

	public function __construct () {
		$this->user_custom = $this->default_settings();

		add_action( 'show_user_profile', array( $this, 'add_field' ) );
		add_action( 'edit_user_profile', array( $this, 'add_field' ) );
		add_action( 'personal_options_update', array( $this, 'save' ) );
		add_action( 'edit_user_profile_update', array( $this, 'save' ) );
	}

	public function get_data ( $user ) {
		$user_id   = $user->ID;
		$user_meta = get_user_meta( $user_id, 'kelly_user_meta', true );
		if ( empty( $user_meta ) ) {
			$user_meta = array();
			foreach ( $this->user_custom as $key => $item ) {
				$user_meta[ $key ] = $item['value'];
			}
			update_user_meta( $user_id, 'kelly_user_meta', $user_meta );
		}

	}

	public function add_field ( $user ) {
		$this->get_data( $user );
		$user_meta = get_user_meta( $user->ID, 'kelly_user_meta', true );
		?>
		<h3><?php esc_html_e( 'Additional Information', 'kelly-wp' ); ?></h3>
		<table class="form-table">
			<?php
			foreach ( $this->user_custom as $key => $settings ) :
				$function = 'render_' . $settings['type'];
				call_user_func( array( $this, $function ), $key, $settings, $user_meta[ $key ] );
			endforeach;
			?>
		</table>
		<?php
	}

	public function render_text ( $key = '', $settings = array(), $value = '' ) {
		?>
		<tr class="kd-<?php echo esc_attr( $key ); ?>">
			<th>
				<label for="field_<?php echo esc_attr( $key ) ?>"><?php echo esc_attr( $settings['title'] ); ?></label>
			<td>
				<div class="wrap-setting-text">
					<input id="field_<?php echo esc_attr( $key ) ?>" class="regular-text" type="text" name="kelly_user_meta[<?php echo esc_attr( $key ); ?>]" value="<?php echo esc_attr( $value ); ?>" />
				</div>
			</td>
			</th>
		</tr>
		<?php
	}

	public function render_textarea ( $key = '', $settings = array(), $value = '' ) {
		?>
		<tr class="kd-<?php echo esc_attr( $key ); ?>">
			<th>
				<label for="field_<?php echo esc_attr( $key ) ?>"><?php echo esc_attr( $settings['title'] ); ?></label>
			<td>
				<div class="wrap-setting-textarea">
					<textarea name="kelly_user_meta[<?php echo esc_attr( $key ); ?>]" id="field_<?php echo esc_attr( $key ) ?>"><?php echo esc_attr( $value ); ?></textarea>
				</div>
				<?php
				if ( ! empty( $settings['description'] ) ) {
					?>
					<p class="description">
						<?php echo wp_kses_post( $settings['description'] ); ?>
					</p>
					<?php
				}
				?>
			</td>
			</th>
		</tr>
		<?php
	}

	public function render_media ( $key = '', $settings = array(), $value = '' ) {
		if ( empty( $settings['image_size'] ) ) {
			$settings['image_size'] = 'thumbnail';
		}
		?>
		<tr class="kd-<?php echo esc_attr( $key ); ?>">
			<th>
				<label for="field_<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $settings['title'] ); ?></label>
			<td>
				<div class="wrap-media">
					<div class="kd-upload" data-parent=".kd-<?php echo esc_attr( $key ); ?> .kd-img-container" data-multiple="false" data-image-size="<?php echo esc_attr( $settings['image_size'] ); ?>">
						<input class="kd-media-value" type="hidden" />
						<input id="field_<?php echo esc_attr( $key ); ?>" class="kd-media-value" type="text" name="kelly_user_meta[<?php echo esc_attr( $key ); ?>]" value="<?php echo esc_attr( $value ); ?>" />
						<a href="#" class="button kd-button kd-btn-upload"><?php esc_html_e( 'Upload', 'kelly-wp' ); ?></a>
						<div class="kd-img-container">
							<?php
							if ( $value != '' ) :
								?>
								<ul class="list-kd-image-media">
									<li class="kd-image">
										<img src="<?php echo esc_url( $value ); ?>" alt="<?php esc_attr( $settings['title'] ); ?>" />
										<div class="kd-control-wrap">
											<i class="kd-edit dashicons dashicons-edit"></i>
											<i class="kd-close dashicons dashicons-no-alt"></i>
										</div>
									</li>
								</ul>
								<?php
							endif;
							?>
						</div>
					</div>
				</div>
				<?php
				if ( ! empty( $settings['description'] ) ) {
					?>
					<p class="description">
						<?php echo wp_kses_post( $settings['description'] ); ?>
					</p>
					<?php
				}
				?>
			</td>
			</th>
		</tr>
		<?php
	}

	public function render_spectrum ( $key = '', $settings = array(), $value = '' ) {
		?>
		<tr class="kd-<?php echo esc_attr( $key ); ?>">
			<th>
				<label for="field_<?php echo esc_attr( $key ) ?>"><?php echo esc_attr( $settings['title'] ); ?></label>
			<td>
				<div class="wrap-setting-spectrum">
					<input id="field_<?php echo esc_attr( $key ) ?>" type="text" name="kelly_user_meta[<?php echo esc_attr( $key ); ?>]" value="<?php echo esc_attr( $value ); ?>" />
				</div>
				<?php
				if ( ! empty( $settings['description'] ) ) {
					?>
					<p class="description">
						<?php echo wp_kses_post( $settings['description'] ); ?>
					</p>
					<?php
				}
				?>
			</td>
			</th>
		</tr>
		<?php
	}

	public function save ( $user_id ) {
		if ( ! current_user_can( 'edit_user', $user_id ) ) {
			return false;
		}

		if ( isset( $_POST['kelly_user_meta'] ) ) {
			update_user_meta( $user_id, 'kelly_user_meta', $_POST['kelly_user_meta'] );
		}
	}
}

new KellyUserSettings;