<?php

define( 'KELLY_VER', '1.0.6' );
define( 'KELLY_DIR', trailingslashit( get_template_directory() ) );
define( 'KELLY_URI', trailingslashit( get_template_directory_uri() ) );

require_once( KELLY_DIR . 'core/init.php' );

add_action( 'init', 'kelly_theme_setup' );
add_action( 'widgets_init', 'kelly_widget_init' );
add_action( 'wp_enqueue_scripts', 'kelly_enqueue_assets' );
add_action( 'wp_enqueue_scripts', 'kelly_custom_css', 999 );
add_filter( 'wp_title', 'kelly_wp_title' );
add_filter( 'wp_head', 'kelly_favicon' );
add_filter( 'wp_head', 'kelly_increase_post_views' );
add_filter( 'wp_head', 'kelly_overwrite_theme_options', 10 );
add_filter( 'body_class', 'kelly_body_class', 10, 2 );
add_filter( 'mce_buttons', 'kelly_add_next_page_button', 1, 2 );
add_filter( 'comment_form_fields', 'kelly_move_comment_field_to_bottom' );
add_action( 'wp_enqueue_scripts', 'kelly_render_js_inline' );
add_filter( 'kelly_image_size', 'kelly_image_size' );
add_filter( 'kd_format_ui_posts_type', 'kelly_format_ui_posts_type' );
add_filter( 'kelly_wrap_left_column', 'kelly_wrap_left_column' );
add_filter( 'kelly_wrap_right_column', 'kelly_wrap_right_column' );
add_filter( 'kelly_wrap_footer', 'kelly_wrap_footer' );
add_filter( 'get_avatar_url', 'kelly_get_avatar_url', 10, 3 );

function kelly_theme_setup () {
	global $kelly_options, $kelly_socials_data;
	$kelly_socials_data = array(
		'behance'     => array(
			'title' => esc_html__( 'Behance', 'kelly-wp' ),
			'class' => 'fa fa-behance'
		),
		'dribbble'    => array(
			'title' => esc_html__( 'Dribbble', 'kelly-wp' ),
			'class' => 'fa fa-dribbble'
		),
		'facebook'    => array(
			'title' => esc_html__( 'Facebook', 'kelly-wp' ),
			'class' => 'fa fa-facebook'
		),
		'flickr'      => array(
			'title' => esc_html__( 'Flickr', 'kelly-wp' ),
			'class' => 'fa fa-flickr'
		),
		'google_plus' => array(
			'title' => esc_html__( 'Google Plus', 'kelly-wp' ),
			'class' => 'fa fa-google-plus'
		),
		'instagram'   => array(
			'title' => esc_html__( 'Instagram', 'kelly-wp' ),
			'class' => 'fa fa-instagram'
		),
		'linkedin'    => array(
			'title' => esc_html__( 'Linkedin', 'kelly-wp' ),
			'class' => 'fa fa-linkedin'
		),
		'mail'        => array(
			'title' => esc_html__( 'Mail', 'kelly-wp' ),
			'class' => 'fa fa-envelope'
		),
		'pinterest'   => array(
			'title' => esc_html__( 'Pinterest', 'kelly-wp' ),
			'class' => 'fa fa-pinterest'
		),
		'rss'       => array(
			'title' => esc_html__( 'Rss', 'kelly-wp' ),
			'class' => 'fa fa-rss'
		),
		'skype'       => array(
			'title' => esc_html__( 'Skype', 'kelly-wp' ),
			'class' => 'fa fa-skype'
		),
		'tumblr'      => array(
			'title' => esc_html__( 'Tumblr', 'kelly-wp' ),
			'class' => 'fa fa-tumblr'
		),
		'twitter'     => array(
			'title' => esc_html__( 'Twitter', 'kelly-wp' ),
			'class' => 'fa fa-twitter'
		),
		'vimeo'       => array(
			'title' => esc_html__( 'Vimeo', 'kelly-wp' ),
			'class' => 'fa fa-vimeo-square'
		),
		'vkontakte'   => array(
			'title' => esc_html__( 'VKontakte', 'kelly-wp' ),
			'class' => 'fa fa-vk'
		),
		'yahoo'       => array(
			'title' => esc_html__( 'Yahoo', 'kelly-wp' ),
			'class' => 'fa fa-yahoo'
		),
		'youtube'     => array(
			'title' => esc_html__( 'Youtube', 'kelly-wp' ),
			'class' => 'fa fa-youtube'
		)
	);

	$kelly_options = kelly_get_theme_options();

	$languages_folder = KELLY_DIR . '/languages';
	load_theme_textdomain( 'kelly-wp', $languages_folder );

	/* Insert RSS Feed link */
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'custom-header' );
	add_theme_support( 'custom-background' );

	/* Add post thumbnail */
	add_theme_support( 'post-thumbnails' );

	/* Add title tag */
	add_theme_support( 'title-tag' );

	/* Create menu */
	add_image_size( 'kelly_600x9999', 600, 9999 );
	register_nav_menus( array(
		'kelly-menu' => esc_html__( 'Kelly Menu', 'kelly-wp' )
	) );

	$GLOBALS['content_width'] = 1000;
}

function kelly_get_theme_options () {
	$kelly_options = (array)get_option( 'kelly_options' );
	$kelly_default = array();

	foreach ( KellyThemeOptions::config_options() as $section ) {
		foreach ( $section['fields'] as $setting ) {

			if ( isset( $setting['default'] ) ) {
				$kelly_default[ $setting['id'] ] = $setting['default'];
			} else {
				$kelly_default[ $setting['id'] ] = '';
			}
		}
	}
	if ( empty( $kelly_options ) ) {
		update_option( 'kelly_options', $kelly_default );
	}
	$kelly_options = array_merge( $kelly_default, $kelly_options );

	return $kelly_options;
}

function kelly_widget_init () {

	/* Create sidebars */
	$kelly_sidebar_1st = array(
		'name'          => esc_html__( 'Footer Column 1st', 'kelly-wp' ),
		'id'            => 'kelly-sidebar-1st',
		'description'   => esc_html__( 'Footer Column 1st', 'kelly-wp' ),
		'class'         => 'kelly-sidebar-1st',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="title">',
		'after_title'   => '</h2>'
	);

	$kelly_sidebar_2nd = array(
		'name'          => esc_html__( 'Footer Column 2nd', 'kelly-wp' ),
		'id'            => 'kelly-sidebar-2nd',
		'description'   => esc_html__( 'Footer Column 2nd', 'kelly-wp' ),
		'class'         => 'kelly-sidebar-2nd',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="title">',
		'after_title'   => '</h2>'
	);

	register_sidebar( $kelly_sidebar_1st );
	register_sidebar( $kelly_sidebar_2nd );
}

function kelly_enqueue_assets () {
	global $kelly_options;
	$main_style = KELLY_URI . 'assets/css/styles.css';
	$main_style = apply_filters( 'kelly_main_style_uri', $main_style );
	wp_register_style( 'bootstrap', KELLY_URI . 'assets/css/libs/bootstrap.min.css', '', '3.3.7', 'all' );
	wp_register_style( 'font-awesome', KELLY_URI . 'assets/css/libs/font-awesome.min.css', '', '4.2.0', 'all' );
	wp_register_style( 'justifiedGallery', KELLY_URI . 'assets/css/libs/justifiedGallery.min.css', '', '3.6.3', 'all' );
	wp_register_style( 'magnific-popup', KELLY_URI . 'assets/css/libs/magnific-popup.css', '', '1.1.0', 'all' );
	wp_register_style( 'kelly-styles', $main_style, '', KELLY_VER, 'all' );
	wp_register_style( 'kelly-custom', KELLY_URI . 'assets/css/custom.css', '', '1.1.0', 'all' );

	wp_register_script( 'justifiedGallery', KELLY_URI . 'assets/js/libs/jquery.justifiedGallery.min.js', array( 'jquery' ), '3.6.3', true );
	wp_register_script( 'magnific-popup', KELLY_URI . 'assets/js/libs/jquery.magnific-popup.js', array( 'jquery' ), '1.1.0', true );
	wp_register_script( 'retina', KELLY_URI . 'assets/js/libs/retina.min.js', array( 'jquery' ), '1.3.0', true );
	wp_register_script( 'kelly-scripts', KELLY_URI . 'assets/js/scripts.js', array( 'jquery' ), KELLY_VER, true );

	if ( ! wp_style_is( 'bootstrap' ) ) {
		wp_enqueue_style( 'bootstrap' );
	}

	if ( ! wp_style_is( 'font-awesome' ) ) {
		wp_enqueue_style( 'font-awesome' );
	}
	if ( ! wp_style_is( 'justifiedGallery' ) ) {
		wp_enqueue_style( 'justifiedGallery' );
		wp_enqueue_script( 'justifiedGallery' );
	}
	if ( ! wp_style_is( 'magnific-popup' ) ) {
		wp_enqueue_style( 'magnific-popup' );
		wp_enqueue_script( 'magnific-popup' );
	}
	wp_enqueue_style( 'kelly-styles' );
	wp_enqueue_style( 'kelly-custom' );

	if ($kelly_options['retina'] === '1') {
		wp_enqueue_script( 'retina' );
	}
	wp_enqueue_script( 'kelly-scripts' );
	if ( is_singular() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	/* Google Font Default Of Template */
	$query_args = array(
		'family' => urlencode( 'Roboto:400,600,700|Lato:400,600,700' ),
		'subset' => 'latin,latin-ext'
	);

	wp_register_style( 'google-font-roboto-lato', add_query_arg( $query_args, "//fonts.googleapis.com/css" ), array(), null );
	wp_enqueue_style( 'google-font-roboto-lato' );
}

function kelly_custom_css () {

	global $kelly_options;

	if ( ! empty( $kelly_options['custom_css'] ) ) {
		wp_add_inline_style( 'kelly-styles', $kelly_options['custom_css'] );
	}
}

function kelly_wp_title ( $title, $sep ) {
	if ( ! function_exists( '_wp_render_title_tag' ) ) {
		global $paged, $page;
		if ( is_feed() ) {
			return $title;
		}
		// Add the site name.
		$title .= get_bloginfo( 'name' );

		// Add the site description for the home/front page.
		$site_description = get_bloginfo( 'description', 'display' );
		if ( $site_description && ( is_home() || is_front_page() ) ) {
			$title = "$title $sep $site_description";
		}
		// Add a page number if necessary.
		if ( $paged >= 2 || $page >= 2 ) {
			$title = "$title $sep " . sprintf( esc_html__( 'Page %s', 'kelly-wp' ), max( $paged, $page ) );
		}
	}

	return $title;
}

function kelly_favicon () {

	global $kelly_options;

	if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {
		if ( ! empty( $kelly_options['favicon'] ) && ! empty( $kelly_options['favicon']['id'] ) ) {

			$favicon = wp_get_attachment_image_src( $kelly_options['favicon']['id'], 'full' );
			if ( ! empty( $favicon ) ) {
				?>
				<link rel="icon" type="image/x-icon" href="<?php echo esc_url( $favicon[0] ); ?>">
				<?php
			}
		}
	}
}

function kelly_increase_post_views () {
	if ( is_single() || is_page() ) {
		$post_id = get_the_ID();
		$views   = get_post_meta( $post_id, 'kelly_post_views', true );
		$views   = absint( $views ) + 1;
		update_post_meta( $post_id, 'kelly_post_views', $views );
	}
}

function kelly_overwrite_theme_options () {
	global $kelly_options;

	foreach ( $kelly_options as $key => $value ) {

		if ( isset( $_GET[ $key ] ) ) {
			$kelly_options[ $key ] = $_GET[ $key ];
		}
	}
}

function kelly_body_class ( $classes, $class ) {

	global $kelly_options;

	if ( $kelly_options['menu_position'] === 'right' ) {
		$classes[] = 'menu-right';
	}
	if ( is_404() ) {
		$classes[] = 'post';
	}

	if ( is_page_template( 'default' ) ) {
		$classes[] = 'post';
	}

	return $classes;
}

function kelly_add_next_page_button ( $buttons, $id ) {
	if ( 'content' != $id ) {
		return $buttons;
	}

	array_splice( $buttons, 13, 0, 'wp_page' );

	return $buttons;
}

function kelly_move_comment_field_to_bottom ( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	$fields['comment'] = $comment_field;

	return $fields;
}

function kelly_render_js_inline () {
	global $kelly_options;
	if ( ! empty( $kelly_options['custom_js'] ) ) {
		wp_add_inline_script( 'kelly-scripts', $kelly_options['custom_js'] );
	}
}

function kelly_wpse_allowedtags () {

	// Add custom tags to this string
	return '<script>,<style>,<br>,<em>,<b>, <span>, <strong>,<i>,<ul>,<ol>,<li>,<a>,<p>';
}


function kelly_format_ui_posts_type ( $posts_type ) {
	$posts_type[] = 'portfolio';
	return $posts_type;
}

function kelly_preloader () {

	global $kelly_options;

	if ( $kelly_options['preloader'] === '1' ) {
		?>
		<!-- Preload -->
		<div id="preload">
			<div class="kd-bounce">
				<div></div>
				<div></div>
			</div>
		</div>
		<!-- Preload -->
		<?php
	}
}

function kelly_wrap_left_column ( $wrap_class ) {

	global $kelly_options;

	if ( $kelly_options['menu_position'] === 'right' ) {
		return 'col-md-3 col-md-push-9';
	}

	return $wrap_class;
}

function kelly_wrap_right_column ( $wrap_class ) {
	global $kelly_options;

	if ( $kelly_options['menu_position'] === 'right' ) {
		return 'col-md-9 col-md-pull-3';
	}

	return $wrap_class;
}

function kelly_wrap_footer ( $wrap_class ) {
	global $kelly_options;

	if ( $kelly_options['menu_position'] === 'right' ) {
		return 'col-md-9';
	}

	return $wrap_class;
}

function kelly_get_avatar_url ( $url, $id_or_email, $args ) {

	if ( is_object( $id_or_email ) && isset( $id_or_email->user_id ) ) {
		$id_or_email = $id_or_email->user_id;
	}

	if ( is_string( $id_or_email ) || is_numeric( $id_or_email ) ) {
		$pos         = strpos( $id_or_email, '@' );
		$author_meta = array();
		if ( $pos === false ) {
			$author_meta = get_user_meta( $id_or_email, 'kelly_user_meta', true );
		} else {
			$user = get_user_by( 'email', $id_or_email );

			if ( isset( $user->ID ) ) {
				$author_meta = get_user_meta( $user->ID, 'kelly_user_meta', true );
			}
		}

		if ( isset( $author_meta['avatar'] ) && $author_meta['avatar'] !== '' ) {
			return $author_meta['avatar'];
		}
	}

	return $url;

}

function kelly_mobile () {
	?>
	<!-- Mobile Menu -->
	<div class="mobile">
		<div class="container">
			<!-- Mobile -->
			<div class="menu-mobile">
				<span class="item item-1"></span>
				<span class="item item-2"></span>
				<span class="item item-3"></span>
			</div>
			<!-- End Mobile -->

			<?php kelly_logo(); ?>
		</div>
	</div>
	<div class="hide-menu"></div>
	<!-- End Mobile Menu -->
	<?php
}

function kelly_logo () {
	global $kelly_options;

	if ( ! empty( $kelly_options['logo_media']['id'] ) ) {
		$logo_media = wp_get_attachment_image_src( $kelly_options['logo_media']['id'], 'large' );

		if ( ! empty( $logo_media ) ) {
			$logo_media = $logo_media[0];
			$logo_mobile = $kelly_options['logo_media_mobile']['id'];

			if (!empty($logo_mobile)) {
				$logo_mobile = wp_get_attachment_image_src( $logo_mobile, 'large' );

				if (!empty($logo_mobile)) {
					$logo_mobile = $logo_mobile[0];
				}
				else {
					$logo_mobile = '';
				}
			}
			?>
			<!-- Logo -->
			<div class="logo">
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
					<img class ="logo-desktop" src="<?php echo esc_url( $logo_media ); ?>" alt="<?php bloginfo( 'name' ); ?>">
					<?php
					if (!empty($logo_mobile)) {
						?>
						<img class ="logo-mobile" src="<?php echo esc_url( $logo_mobile ); ?>" alt="<?php bloginfo( 'name' ); ?>">
						<?php
					}
					?>
				</a>
			</div>
			<!-- End Logo -->
			<?php
			return;
		}
	}

	if ( empty( $kelly_options['logo'] ) ) {
		return;
	}
	?>
	<!-- Logo -->
	<div class="logo">
		<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo wp_kses_post( $kelly_options['logo'] ); ?></a>
	</div>
	<!-- End Logo -->
	<?php
}

function kelly_header () {
	global $kelly_options;
	?>
	<div class="header affix">
		<div class="table">
			<div class="table-cell">
				<?php kelly_logo(); ?>

				<?php
				if ( has_nav_menu( 'kelly-menu' ) ) {
					?>
					<!-- Navigation -->
					<div class="main-menu">
						<nav>
							<?php
							wp_nav_menu( array(
								'theme_location'  => 'kelly-menu',
								'container'       => '',
								'container_class' => '',
								'menu_id'         => 'kelly-menu',
								'menu_class'      => 'menu-list',
								'depth'           => 2,
								'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
							) );
							?>
						</nav>
					</div>
					<!-- End Navigation -->
					<?php
				}
				?>

				<?php
				if ( $kelly_options['footer_socials'] === '1' ) {
					global $kelly_socials_data;

					$query_search = get_search_query();
					?>
					<!-- Socials -->
					<div class="socials">
						<?php
						foreach ( $kelly_socials_data as $key => $social ) {

							if ( ! empty( $kelly_options[ $key ] ) ) {
								?>
								<a href="<?php echo esc_url( $kelly_options[ $key ] ); ?>" title="<?php echo esc_attr( $social['title'] ); ?>">
									<i class="<?php echo esc_attr( $social['class'] ); ?>"></i>
								</a>
								<?php
							}
						}
						?>

						<a href="#" title="<?php echo esc_attr(esc_html__( 'Search this site', 'kelly-wp' )); ?>">
							<i class="fa fa-search"></i>
						</a>
					</div>

					<div class="box-search">
						<div class="table">
							<div class="table-cell">
								<div class="container">
									<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
										<input type="search" name="s" class="search-field" placeholder="<?php echo esc_attr(esc_html__( 'Type & hit enter', 'kelly-wp' )); ?>" value="<?php echo esc_attr( $query_search ); ?>" title="<?php echo esc_attr(esc_html__( 'Search', 'kelly-wp' )); ?>">
										<div class="kd-close">
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>

					<!-- End Socials -->
					<?php
				}
				?>

				<?php
				if ( $kelly_options['copyright'] != '' ) {
					?>
					<!-- Copyright -->
					<div class="copyright">
						<p>
							<?php echo wp_kses_post( $kelly_options['copyright'] ); ?>
						</p>
					</div>
					<!-- End Copyright -->
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}

function header_text() {

	global $kelly_options;
	if (
		( is_front_page() && $kelly_options['header_text_home'] === '1' )
		|| ( is_home() && $kelly_options['header_text_blog'] === '1' )
		|| ( is_singular('post') && $kelly_options['header_text_post'] === '1' )
		|| ( is_page() && $kelly_options['header_text_page'] !== '1' )
		|| ( is_singular('portfolio') && $kelly_options['header_text_project'] === '1' )
		|| ( is_tax('project_category') && $kelly_options['header_text_project_category'] === '1' )
		|| ( is_category() && $kelly_options['header_text_category'] === '1' )
		|| ( is_tag() && $kelly_options['header_text_tags'] === '1' )

	) {
		if ( ! empty( $kelly_options['header_text'] ) && $kelly_options['header_text_enable'] === '1' ) {
			?>
			<div class="header-text">
				<blockquote>
					<p>
						<?php echo wp_kses_post( $kelly_options['header_text'] ); ?>
					</p>
					<?php
					if ( ! empty( $kelly_options['header_text_sign'] ) ) {
						?>
						<footer>
							<?php echo wp_kses_post( $kelly_options['header_text_sign'] ); ?>
						</footer>
						<?php
					}
					?>
				</blockquote>
			</div>
			<?php
		}
	}
}

function kelly_footer () {
	?>
	<!-- Footer -->
	<footer id="footer" class="footer">
		<div class="container">
			<div class="row">
				<?php get_sidebar(); ?>
			</div>
		</div>
	</footer>
	<!-- End Footer -->
	<?php
}

function kelly_posts ( $query ) {

	global $kelly_options;

	if ( $query->have_posts() ) {
		while ( $query->have_posts() ) {
			$query->the_post();

			?>
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<?php
				if ( has_post_thumbnail() && $kelly_options['home_image'] ) {
					?>
					<a href="<?php the_permalink(); ?>">
						<?php the_post_thumbnail( 'kelly_600x9999' ); ?>
					</a>
					<?php
				}
				?>

				<div class="post-content">
					<h2 class="title">
						<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
					</h2>

					<?php kelly_post_details(); ?>

					<!-- The Content -->
					<div class="the-excerpt">
						<?php

						?>
						<?php the_excerpt(); ?>
					</div>

					<?php
					if ( ! empty( $kelly_options['home_read_more'] ) ) {
						?>
						<a href="<?php the_permalink(); ?>" class="read-more"><?php echo wp_kses_post( $kelly_options['home_read_more'] ); ?></a>
						<?php
					}
					?>
				</div>
			</article>
			<?php
		}
		kelly_pagination();
		wp_reset_postdata();
	}

	else {
		if (is_search()) {
			?>
			<div class="search-empty">
				<h3>
					<?php esc_html_e('Nothing Found', 'kelly-wp'); ?>
				</h3>
				<p>
					<?php esc_html_e('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'kelly-wp'); ?>
				</p>
			</div>
			<?php
		}

	}

}

function kelly_post_details () {

	global $kelly_options;

	$prefix = 'home';

	if ( is_single() ) {
		$prefix = 'post';
	}
	if ( is_page() ) {
		$prefix = 'page';
	}
	$post_id = get_the_ID();
	$views   = get_post_meta( $post_id, 'kelly_post_views', true );
	if ( empty( $views ) ) {
		$views = 0;
	} else {
		$views = absint($views);
	}
	if ($views <=1) {
		$views = $views . esc_html__( ' view', 'kelly-wp' );
	}
	else {
		$views = $views . esc_html__( ' views', 'kelly-wp' );
	}
	?>
	<!-- Post Details -->
	<div class="post-details">
		<?php
		if ( $kelly_options[ $prefix . '_date' ] === '1' ) {
			?>
			<span class="post-date"><?php echo get_the_date(); ?></span>
			<?php
		}

		if ( $kelly_options[ $prefix . '_views' ] === '1' ) {

			?>
			<span class="post-views"><?php echo wp_kses_post( $views ); ?></span>
			<?php
		}

		if ( $kelly_options[ $prefix . '_comment_count' ] === '1' && comments_open() ) {
			?>
			<a href="<?php comments_link(); ?>" class="post-comments">
				<?php comments_number( esc_html__( '0 Comment', 'kelly-wp' ), esc_html__( '1 Comment', 'kelly-wp' ), '%' . esc_html__( ' Comments', 'kelly-wp' ) ); ?>
			</a>
			<?php
		}
		?>
	</div>
	<!-- End Post Details -->
	<?php
}

function kelly_pagination ( $query = array() ) {
	global $wp_query;


	$temp = $wp_query;

	if ( ! empty( $query ) ) {
		$wp_query = $query;
	}

	$pages = paginate_links( array(
		'format'             => '?paged=%#%',
		'prev_text'          => '<i class="fa fa-long-arrow-left"></i>',
		'next_text'          => '<i class="fa fa-long-arrow-right"></i>',
		'before_page_number' => '',
		'after_page_number'  => '',
		'show_all'           => false,
		'type'               => 'array',
		'total'              => $wp_query->max_num_pages,
	) );

	$wp_query = $temp;

	if ( is_array( $pages ) ) {
		?>
		<!-- Pagination -->
		<div class="pagination-wrap">
			<ul>
				<?php
				foreach ( $pages as $key => $page ) {
					?>
					<li><?php echo "$page"; ?></li>
					<?php
				}
				?>
			</ul>
		</div>
		<!-- End Pagination -->
		<?php
	}
}

function kelly_comment_nav () {
	if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) {
		?>
		<nav class="navigation comment-navigation" role="navigation">
			<div class="nav-links clearfix">
				<?php
				$older_comments = esc_html__( 'Older Comments', 'kelly-wp' );
				$newer_comments = esc_html__( 'Newer Comments', 'kelly-wp' );
				if ( $prev_link = get_previous_comments_link( $older_comments ) ) :
					printf( '<div class="nav-previous">%s</div>', $prev_link );
				endif;

				if ( $next_link = get_next_comments_link( $newer_comments ) ) :
					printf( '<div class="nav-next">%s</div>', $next_link );
				endif;
				?>
			</div>
		</nav>
		<?php
	}
}

function kelly_callback_comments ( $comment, $args, $depth ) {

	$author_url  = $comment->comment_author_url;
	$before_html = $after_html = '';

	if ( empty( $author_url ) ) {
		$user = get_user_by( 'email', $comment->comment_author_email );
		if ( ! empty( $user ) ) {
			$author_url = $user->user_url;
		}
	}
	if ( ! empty( $author_url ) ) {
		$before_html = '<a href="' . esc_url( $author_url ) . '">';
		$after_html  = '</a>';
	}

	switch ( $comment->comment_type ) {
		case 'pingback':
		case 'trackback':
			?>
			<li id="comment-<?php comment_ID(); ?>" <?php comment_class(); ?>>
				<div class="comment-body">
					<div class="comment-avatar">
						<?php
						echo wp_kses_post( $before_html );
						?>
						<img src="<?php echo esc_url( KELLY_URI . 'assets/images/pinkback.png' ); ?>" alt="<?php echo esc_html( $comment->comment_author ); ?>">
						<?php
						echo wp_kses_post( $after_html );
						?>
					</div>
					<div class="comment-context">
						<div class="comment-head">
							<h2 class="title">
								<?php
								echo wp_kses_post( $before_html );
								echo wp_kses_post( $comment->comment_author );
								echo wp_kses_post( $after_html );
								?>
							</h2>
							<span class="comment-date">
							<?php echo get_comment_date(); ?>
						</span>
						</div>
						<div class="comment-content">
							<?php
							if ( ! $comment->comment_approved ) {
								?>
								<p class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'kelly-wp' ); ?></p>
								<?php
							} else {
								comment_text();
							}
							?>
						</div>
						<div class="reply">
							<?php
							comment_reply_link(
								array_merge( $args,
									array(
										'before'     => '<span class="comment-reply">',
										'after'      => '</span>',
										'reply_text' => esc_html__( 'Reply', 'kelly-wp' ),
										'depth'      => $depth,
										'max_depth'  => $args['max_depth']
									)
								),
								$comment->comment_ID
							);
							edit_comment_link( esc_html__( 'Edit', 'kelly-wp' ), '<span class="comment-edit">', '</span>' );
							?>
						</div>
					</div>
				</div>
			</li>
			<?php
			break;
		default:
			?>
			<li id="comment-<?php comment_ID(); ?>" <?php comment_class(); ?>>
				<div class="comment-body">
					<div class="comment-avatar">
						<?php
						echo wp_kses_post( $before_html );
						echo get_avatar( $comment->comment_author_email, 70 );
						echo wp_kses_post( $after_html );
						?>
					</div>
					<div class="comment-context">
						<div class="comment-head">
							<h2 class="title">
								<?php
								echo wp_kses_post( $before_html );
								echo wp_kses_post( $comment->comment_author );
								echo wp_kses_post( $after_html );
								?>
							</h2>
							<span class="comment-date">
								<?php echo get_comment_date(); ?>
							</span>
						</div>
						<div class="comment-content">
							<?php
							if ( ! $comment->comment_approved ) {
								?>
								<p class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'kelly-wp' ); ?></p>
								<?php
							} else {
								comment_text();
							}
							?>
						</div>
						<div class="reply">
							<?php
							comment_reply_link(
								array_merge( $args,
									array(
										'before'     => '<span class="comment-reply">',
										'after'      => '</span>',
										'reply_text' => esc_html__( 'Reply', 'kelly-wp' ),
										'depth'      => $depth,
										'max_depth'  => $args['max_depth']
									)
								),
								$comment->comment_ID
							);
							edit_comment_link( esc_html__( 'Edit', 'kelly-wp' ), '<span class="comment-edit">', '</span>' );
							?>
						</div>
					</div>
				</div>
			</li>
			<?php
	}
}

function kelly_archive_external_query () {
	$arg_query = array();

	if ( is_category() ) {

		$category                   = get_term_by( 'name', single_cat_title( '', false ), 'category' );
		$arg_query['category_name'] = $category->slug;

	} else if ( is_author() ) {

		$author              = get_queried_object();
		$arg_query['author'] = $author->ID;

	} else if ( is_tag() ) {

		$tag              = get_term_by( 'name', single_cat_title( '', false ), 'post_tag' );
		$arg_query['tag'] = $tag->slug;

	} else if ( is_date() ) {

		$arg_query['monthnum'] = get_query_var( 'monthnum' );
		$arg_query['year']     = get_query_var( 'year' );
		$arg_query['day']      = get_query_var( 'day' );

	} else if ( is_search() ) {

		$arg_query['s'] = get_search_query();

	} else if ( is_tax( 'post_format' ) ) {

		$post_format = get_post_format();

		if ( ! empty( $post_format ) ) {
			$arg_query['tax_query'] = array(
				array(
					'taxonomy' => 'post_format',
					'field'    => 'slug',
					'terms'    => 'post-format-' . $post_format
				)
			);
		}
	}

	return $arg_query;
}

function kelly_projects ( $query, $taxonomy = '' ) {
	if ( empty( $query ) || ! $query->have_posts() ) {
		return;
	}

	global $kelly_options;

	$layout = 'list';

	if ( ! empty( $kelly_options['portfolio_layout'] ) ) {
		$layout = $kelly_options['portfolio_layout'];
	}

	if ($kelly_options['project_lightbox'] === '1') {
		$layout .= ' project-lightbox';
	}

	?>
	<div class="<?php echo esc_attr( $layout ); ?>">
		<?php
		while ( $query->have_posts() ) {
			$query->the_post();

			?>
			<div class="project-item">
				<?php
				if ($kelly_options['project_lightbox'] === '1') {
					if ( has_post_thumbnail() ) {
						?>
						<a href="<?php echo get_the_post_thumbnail_url( get_the_ID(), 'full' ); ?>" class="popup" title="<?php the_title(); ?>">
							<?php the_post_thumbnail( 'kelly_600x9999' ); ?>
						</a>
						<?php
					}
					?>
					<h2 class="title">
						<span><?php the_title(); ?></span>
					</h2>
					<?php
				}
				else {
					if ( has_post_thumbnail() ) {
						?>
						<a href="<?php the_permalink(); ?>">
							<?php the_post_thumbnail( 'kelly_600x9999' ); ?>
						</a>
						<?php
					}
					?>
					<h2 class="title">
						<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
					</h2>
					<?php
				}
				?>
			</div>
			<?php
		}
		?>
	</div>
	<?php
	kelly_pagination( $query );
	wp_reset_postdata();

}