<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

	<!-- Wrapper Site -->
	<div id="main-content">
		<?php kelly_preloader(); ?>
		<?php kelly_mobile(); ?>

		<div class="container">
			<div class="row">
				<?php
				$wrap_left = apply_filters('kelly_wrap_left_column', 'col-md-3');
				$wrap_right = apply_filters('kelly_wrap_right_column', 'col-md-9');
				?>

				<div class="<?php echo esc_attr($wrap_left); ?>">
					<?php kelly_header(); ?>
				</div>

				<div class="<?php echo esc_attr($wrap_right); ?>">
					<div class="projects">
						<?php header_text(); ?>

