<?php
if ( is_front_page() ) {
	get_template_part( 'archive', 'portfolio' );
	exit();
}
?>

<?php get_header(); ?>
<?php
global $kelly_options;

the_post();
?>
<article id="post-<?php the_ID();?>" <?php post_class(); ?>>
	<?php
	if ($kelly_options['page_thumbnail'] & has_post_thumbnail()) {
		?>
		<div class="post-media">
			<?php the_post_thumbnail('kelly_600x9999'); ?>
		</div>
		<?php
	}
	?>

	<div class="post-content">
		<h2 class="title"><?php the_title(); ?></h2>

		<?php kelly_post_details(); ?>

		<!-- The Content -->
		<div class="the-content">
			<?php
			the_content();
			wp_link_pages(array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'kelly-wp' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'separator'   => '<span class="screen-reader-text">, </span>',
			));
			?>
		</div>
		<!-- End The Content -->

		<div class="post-footer">
			<?php
			if ($kelly_options['page_share'] === '1' && shortcode_exists( 'kd_share_post' )) {
				?>
				<div class="post-share-wrap">
					<div class="post-share">
						<?php
						do_shortcode( '[kd_share_post]' );
						?>
					</div>
				</div>
				<?php
			}
			?>
		</div>

		<?php
		if ($kelly_options['page_comments'] === '1') {
			comments_template();
		}
		?>
	</div>
</article>
<?php get_footer(); ?>
