<?php get_header(); ?>
<?php
the_post();
$post_id = get_the_ID();
$meta    = get_post_meta( $post_id );
$images  = array();
$client  = $client_url = $date = $location = $budget = $project_name = $project_url = $share = '';
if ( isset( $meta['kelly_only_images'] ) && ! empty( $meta['kelly_only_images'] ) ) {
	$images = $meta['kelly_only_images'];
}

if ( isset( $meta['kelly_only_date'] ) && ! empty( $meta['kelly_only_date'] ) ) {
	$date = $meta['kelly_only_date'][0];
}
if ( isset( $meta['kelly_only_client'] ) && ! empty( $meta['kelly_only_client'] ) ) {
	$client = $meta['kelly_only_client'][0];
}
if ( isset( $meta['kelly_only_client_url'] ) && ! empty( $meta['kelly_only_client_url'] ) ) {
	$client_url = $meta['kelly_only_client_url'][0];
}
if ( isset( $meta['kelly_only_location'] ) && ! empty( $meta['kelly_only_location'] ) ) {
	$location = $meta['kelly_only_location'][0];
}
if ( isset( $meta['kelly_only_budget'] ) && ! empty( $meta['kelly_only_budget'] ) ) {
	$budget = $meta['kelly_only_budget'][0];
}
if ( isset( $meta['kelly_only_project_name'] ) && ! empty( $meta['kelly_only_project_name'] ) ) {
	$project_name = $meta['kelly_only_project_name'][0];
}
if ( isset( $meta['kelly_only_project_url'] ) && ! empty( $meta['kelly_only_project_url'] ) ) {
	$project_url = $meta['kelly_only_project_url'][0];
}
if ( isset( $meta['kelly_only_share'] ) && ! empty( $meta['kelly_only_share'] ) ) {
	$share = $meta['kelly_only_share'][0];
}
?>
<div class="project">
	<div class="detail-content">
		<h2 class="title"><?php the_title(); ?></h2>
		<div class="the-content">
			<?php
			the_content();
			wp_link_pages(array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'kelly-wp' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'separator'   => '<span class="screen-reader-text">, </span>',
			));
			?>
		</div>
		<div class="project-attributes">
			<table>
				<tbody>
				<?php
				if ( ! empty( $client ) ) {
					?>
					<tr>
						<td class="name"><?php esc_html_e( 'Client', 'kelly-wp' ); ?></td>
						<td class="value">
							<?php
							$before = $after = '';
							if ( ! empty( $client_url ) ) {
								$before = '<a href="' . esc_url( $client_url ) . '">';
								$after  = '</a>';
							}
							echo wp_kses_post( $before );
							echo wp_kses_post( $client );
							echo wp_kses_post( $after );
							?>
						</td>
					</tr>
					<?php
				}

				if ( ! empty( $date ) ) {
					?>
					<tr>
						<td class="name"><?php esc_html_e( 'Date', 'kelly-wp' ); ?></td>
						<td class="value"><?php echo wp_kses_post( $date ); ?></td>
					</tr>
					<?php
				}

				if ( ! empty( $location ) ) {
					?>
					<tr>
						<td class="name"><?php esc_html_e( 'Location', 'kelly-wp' ); ?></td>
						<td class="value"><?php echo wp_kses_post( $location ); ?></td>
					</tr>
					<?php
				}

				if ( ! empty( $budget ) ) {
					?>
					<tr>
						<td class="name"><?php esc_html_e( 'Budget', 'kelly-wp' ); ?></td>
						<td class="value"><?php echo wp_kses_post( $budget ); ?></td>
					</tr>
					<?php
				}

				if ( ! empty( $project_name ) ) {
					$before = $after = '';
					if (!empty($project_url)) {
						$before = '<a href="'.esc_url($project_url).'">';
						$after = '</a>';
					}
					?>
					<tr>
						<td class="name"><?php esc_html_e( 'Project', 'kelly-wp' ); ?></td>
						<td class="value">
							<?php echo wp_kses_post( $before. $project_name .$after); ?>
						</td>
					</tr>
					<?php
				}
				$category =  wp_get_post_terms( $post_id, 'project_category');

				if (count($category)) {
					?>
					<tr>
						<td class="name"><?php esc_html_e( 'Category', 'kelly-wp' ); ?></td>
						<td class="value">
							<?php
							foreach ($category as $id => $item) {
								echo wp_kses_post($item->name);

								if ($id < (count($category) - 1)) {
									echo ', ';
								}
							}
							?>
						</td>
					</tr>
					<?php
				}

				if ($share != 'not_share' && shortcode_exists( 'kd_share_post' )) {
					?>
					<tr>
						<td class="name"><?php esc_html_e( 'Share', 'kelly-wp' ); ?></td>
						<td class="value">
							<div class="socials">
								<?php echo do_shortcode( '[kd_share_post]' ); ?>
							</div>
						</td>
					</tr>
					<?php
				}
				?>

				</tbody>
			</table>
		</div>
	</div>

	<?php
	$post_format = get_post_format();
	if (!empty($post_format)) {
		?>
		<div class="support-post-format">
			<?php do_shortcode( '[kd_formats_ui]' ); ?>
		</div>
		<?php
	}
	if ( ! empty( $images ) ) {
		?>
		<div class="images-project">
			<?php
			foreach ( $images as $image_id ) {
				$image_url  = wp_get_attachment_image_src( $image_id, 'kelly_600x9999' );
				$image_full = wp_get_attachment_image_src( $image_id, 'full' );

				if ( isset( $image_url[0] ) && $image_url[0] !== '' ) {
					$image_url = $image_url[0];
				} else {
					continue;
				}
				if ( isset( $image_full[0] ) && $image_full[0] !== '' ) {
					$image_full = $image_full[0];
				}
				?>
				<a href="<?php echo esc_url( $image_full ); ?>" class="popup" title="<?php echo get_the_title($image_id); ?>">
					<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo get_the_title($image_id); ?>">
				</a>
				<?php
			}
			?>
		</div>
		<?php
	}
	?>

	<?php
	$prev_id = get_previous_post();
	$next_id = get_next_post();
	?>

	<!-- Navigation -->
	<div class="navigation-wrap">
		<?php
		if ( ! empty( $next_id ) ) {
			?>
			<a href="<?php echo esc_url( get_permalink( $next_id ) ); ?>" class="page-numbers"><i class="fa fa-angle-left"></i></a>
			<?php
		}
		?>
		<a class='page-numbers' href='<?php echo esc_url(home_url( '/' )); ?>'><i class="fa fa-th"></i></a>
		<?php
		if ( ! empty( $prev_id ) ) {
			?>
			<a href="<?php echo esc_url( get_permalink( $prev_id ) ); ?>" class="page-numbers"><i class="fa fa-angle-right"></i></a>
			<?php
		}
		?>
	</div>
	<!-- End Navigation -->

</div>

<?php get_footer(); ?>
