<?php get_header(); ?>
<?php
global $kelly_options;

the_post();
?>
<article id="post-<?php the_ID();?>" <?php post_class(); ?>>
	<?php
	if ($kelly_options['post_thumbnail'] === '1') {
		$flag = false;
		$post_format = get_post_format();

		if (!empty($post_format)) {
			?>
			<div class="post-media">
				<?php do_shortcode( '[kd_formats_ui]' ); ?>
			</div>
			<?php
			$flag = true;
		}

		if (has_post_thumbnail() && !$flag) {
			?>
			<div class="post-media">
				<?php the_post_thumbnail('kelly_600x9999'); ?>
			</div>
			<?php
		}
	}
	?>

	<div class="post-content">
		<h2 class="title"><?php the_title(); ?></h2>

		<?php kelly_post_details(); ?>

		<!-- The Content -->
		<div class="the-content">
			<?php
			the_content();
			wp_link_pages(array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'kelly-wp' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'separator'   => '<span class="screen-reader-text">, </span>',
			));
			?>
		</div>
		<!-- End The Content -->

		<div class="post-footer">
			<?php
			if ($kelly_options['post_share'] === '1' && shortcode_exists( 'kd_share_post' )) {
				?>
				<div class="post-share-wrap">
					<div class="post-share">
						<?php
						do_shortcode( '[kd_share_post]' );
						?>
					</div>
				</div>
				<?php
			}

			if ($kelly_options['post_category'] === '1') {
				?>
				<!-- Post Category -->
				<div class="cat">
					<strong><?php esc_html_e('Category: ', 'kelly-wp'); ?></strong><?php the_category(' '); ?>
				</div>
				<!-- End Post Category -->
				<?php
			}

			if ($kelly_options['post_tags'] === '1') {
				the_tags( ' <div class="post-tags">', '&#09;', '</div>' );
			}
			?>
		</div>

		<?php
		if ($kelly_options['post_navigation'] === '1') {
			$prevID = get_previous_post();
			$nextID = get_next_post();

			if (!empty($prevID) || !empty($nextID)) {
				?>
				<!-- Next and Previous Posts -->
				<div class="navigation-post clearfix">
					<div class="row">
						<div class="col-sm-6">
							<?php
							if (!empty($nextID)) {
								?>
								<div class="new-post">
									<div class="item-content">
										<h3 class="item-title" title="<?php esc_html_e('Next', 'kelly-wp'); ?>">
											<a href="<?php echo esc_url(get_permalink($nextID)); ?>">
												<i class="fa fa-chevron-left"></i>
												<?php echo get_the_title($nextID); ?></a>
										</h3>
									</div>
								</div>
								<?php
							}
							?>
						</div>
						<div class="col-sm-6">
							<?php
							if (!empty($prevID)) {
								?>
								<div class="old-post">
									<div class="item-content">
										<h3 class="item-title" title="<?php esc_html_e('Previous', 'kelly-wp'); ?>">
											<a href="<?php echo esc_url(get_permalink($prevID)); ?>">
												<?php echo get_the_title($prevID); ?>
												<i class="fa fa-chevron-right"></i>
											</a>
										</h3>
									</div>
								</div>
								<?php
							}
							?>
						</div>
					</div>
				</div>
				<!-- End Next and Previous Posts -->
				<?php
			}
		}
		?>

		<?php
		if ($kelly_options['post_comments'] === '1') {
			comments_template();
		}
		?>
	</div>
</article>

<?php get_footer(); ?>
